"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, table_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the status of Kinesis streaming.

    Args:
        table_name(str): The name of the table being described.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.kinesis_streaming_destination.describe(
                ctx, table_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.kinesis_streaming_destination.describe table_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="describe_kinesis_streaming_destination",
        op_kwargs={"TableName": table_name},
    )


async def disable(hub, ctx, table_name: str, stream_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops replication from the DynamoDB table to the Kinesis data stream. This is done without deleting either of the resources.

    Args:
        table_name(str): The name of the DynamoDB table.
        stream_arn(str): The ARN for a Kinesis data stream.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.kinesis_streaming_destination.disable(
                ctx, table_name=value, stream_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.kinesis_streaming_destination.disable table_name=value, stream_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="disable_kinesis_streaming_destination",
        op_kwargs={"TableName": table_name, "StreamArn": stream_arn},
    )


async def enable(hub, ctx, table_name: str, stream_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Starts table data replication to the specified Kinesis data stream at a timestamp chosen during the enable workflow. If this operation doesn't return results immediately, use DescribeKinesisStreamingDestination to check if streaming to the Kinesis data stream is ACTIVE.

    Args:
        table_name(str): The name of the DynamoDB table.
        stream_arn(str): The ARN for a Kinesis data stream.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.kinesis_streaming_destination.enable(
                ctx, table_name=value, stream_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.kinesis_streaming_destination.enable table_name=value, stream_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="enable_kinesis_streaming_destination",
        op_kwargs={"TableName": table_name, "StreamArn": stream_arn},
    )
