"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(hub, ctx, global_table_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes Region-specific settings for a global table.  This operation only applies to Version 2017.11.29 of global tables.

    Args:
        global_table_name(str): The name of the global table to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.global_table.setting.describe_all(
                ctx, global_table_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.global_table.setting.describe_all global_table_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="describe_global_table_settings",
        op_kwargs={"GlobalTableName": global_table_name},
    )


async def update_multiple(
    hub,
    ctx,
    global_table_name: str,
    global_table_billing_mode: str = None,
    global_table_provisioned_write_capacity_units: int = None,
    global_table_provisioned_write_capacity_auto_scaling_settings_update: Dict = None,
    global_table_global_secondary_index_settings_update: List = None,
    replica_settings_update: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates settings for a global table.

    Args:
        global_table_name(str): The name of the global table.
        global_table_billing_mode(str, optional): The billing mode of the global table. If GlobalTableBillingMode is not specified, the global table defaults to PROVISIONED capacity billing mode.    PROVISIONED - We recommend using PROVISIONED for predictable workloads. PROVISIONED sets the billing mode to Provisioned Mode.    PAY_PER_REQUEST - We recommend using PAY_PER_REQUEST for unpredictable workloads. PAY_PER_REQUEST sets the billing mode to On-Demand Mode.   . Defaults to None.
        global_table_provisioned_write_capacity_units(int, optional): The maximum number of writes consumed per second before DynamoDB returns a ThrottlingException. . Defaults to None.
        global_table_provisioned_write_capacity_auto_scaling_settings_update(Dict, optional): Auto scaling settings for managing provisioned write capacity for the global table. Defaults to None.
        global_table_global_secondary_index_settings_update(List, optional): Represents the settings of a global secondary index for a global table that will be modified. Defaults to None.
        replica_settings_update(List, optional): Represents the settings for a global table in a Region that will be modified. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.global_table.setting.update_multiple(
                ctx, global_table_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.global_table.setting.update_multiple global_table_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="update_global_table_settings",
        op_kwargs={
            "GlobalTableName": global_table_name,
            "GlobalTableBillingMode": global_table_billing_mode,
            "GlobalTableProvisionedWriteCapacityUnits": global_table_provisioned_write_capacity_units,
            "GlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdate": global_table_provisioned_write_capacity_auto_scaling_settings_update,
            "GlobalTableGlobalSecondaryIndexSettingsUpdate": global_table_global_secondary_index_settings_update,
            "ReplicaSettingsUpdate": replica_settings_update,
        },
    )
