"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, global_table_name: str, replication_group: List) -> Dict:
    r"""
    **Autogenerated function**

    Creates a global table from an existing table. A global table creates a replication relationship between two or more DynamoDB tables with the same table name in the provided Regions.   This operation only applies to Version 2017.11.29 of global tables.  If you want to add a new replica table to a global table, each of the following conditions must be true:   The table must have the same primary key as all of the other replicas.   The table must have the same name as all of the other replicas.   The table must have DynamoDB Streams enabled, with the stream containing both the new and the old images of the item.   None of the replica tables in the global table can contain any data.    If global secondary indexes are specified, then the following conditions must also be met:     The global secondary indexes must have the same name.     The global secondary indexes must have the same hash key and sort key (if present).     If local secondary indexes are specified, then the following conditions must also be met:     The local secondary indexes must have the same name.     The local secondary indexes must have the same hash key and sort key (if present).      Write capacity settings should be set consistently across your replica tables and secondary indexes. DynamoDB strongly recommends enabling auto scaling to manage the write capacity settings for all of your global tables replicas and indexes.   If you prefer to manage write capacity settings manually, you should provision equal replicated write capacity units to your replica tables. You should also provision equal replicated write capacity units to matching secondary indexes across your global table.

    Args:
        global_table_name(str): The global table name.
        replication_group(List): The Regions where the global table needs to be created.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.global_table.init.create(
                ctx, global_table_name=value, replication_group=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.global_table.init.create global_table_name=value, replication_group=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="create_global_table",
        op_kwargs={
            "GlobalTableName": global_table_name,
            "ReplicationGroup": replication_group,
        },
    )


async def describe(hub, ctx, global_table_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the specified global table.  This operation only applies to Version 2017.11.29 of global tables. If you are using global tables Version 2019.11.21 you can use DescribeTable instead.

    Args:
        global_table_name(str): The name of the global table.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.global_table.init.describe(
                ctx, global_table_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.global_table.init.describe global_table_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="describe_global_table",
        op_kwargs={"GlobalTableName": global_table_name},
    )


async def list_all(
    hub,
    ctx,
    exclusive_start_global_table_name: str = None,
    limit: int = None,
    region_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all global tables that have a replica in the specified Region.  This operation only applies to Version 2017.11.29 of global tables.

    Args:
        exclusive_start_global_table_name(str, optional): The first global table name that this operation will evaluate. Defaults to None.
        limit(int, optional): The maximum number of table names to return, if the parameter is not specified DynamoDB defaults to 100. If the number of global tables DynamoDB finds reaches this limit, it stops the operation and returns the table names collected up to that point, with a table name in the LastEvaluatedGlobalTableName to apply in a subsequent operation to the ExclusiveStartGlobalTableName parameter. Defaults to None.
        region_name(str, optional): Lists the global tables in a specific Region. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.global_table.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.global_table.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="list_global_tables",
        op_kwargs={
            "ExclusiveStartGlobalTableName": exclusive_start_global_table_name,
            "Limit": limit,
            "RegionName": region_name,
        },
    )


async def update(hub, ctx, global_table_name: str, replica_updates: List) -> Dict:
    r"""
    **Autogenerated function**

    Adds or removes replicas in the specified global table. The global table must already exist to be able to use this operation. Any replica to be added must be empty, have the same name as the global table, have the same key schema, have DynamoDB Streams enabled, and have the same provisioned and maximum write capacity units.  Although you can use UpdateGlobalTable to add replicas and remove replicas in a single request, for simplicity we recommend that you issue separate requests for adding or removing replicas.   If global secondary indexes are specified, then the following conditions must also be met:     The global secondary indexes must have the same name.     The global secondary indexes must have the same hash key and sort key (if present).     The global secondary indexes must have the same provisioned and maximum write capacity units.

    Args:
        global_table_name(str): The global table name.
        replica_updates(List): A list of Regions that should be added or removed from the global table.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.global_table.init.update(
                ctx, global_table_name=value, replica_updates=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.global_table.init.update global_table_name=value, replica_updates=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="update_global_table",
        op_kwargs={
            "GlobalTableName": global_table_name,
            "ReplicaUpdates": replica_updates,
        },
    )
