"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, export_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes an existing table export.

    Args:
        export_arn(str): The Amazon Resource Name (ARN) associated with the export.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.export.describe(ctx, export_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.export.describe export_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="describe_export",
        op_kwargs={"ExportArn": export_arn},
    )


async def list_all(
    hub, ctx, table_arn: str = None, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists completed exports within the past 90 days.

    Args:
        table_arn(str, optional): The Amazon Resource Name (ARN) associated with the exported table. Defaults to None.
        max_results(int, optional): Maximum number of results to return per page. Defaults to None.
        next_token(str, optional): An optional string that, if supplied, must be copied from the output of a previous call to ListExports. When provided in this manner, the API fetches the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.export.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.export.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="list_exports",
        op_kwargs={
            "TableArn": table_arn,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
