"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, statements: List) -> Dict:
    r"""
    **Autogenerated function**

     This operation allows you to perform batch reads and writes on data stored in DynamoDB, using PartiQL.

    Args:
        statements(List):  The list of PartiQL statements representing the batch to run. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.execute_statement.batch(ctx, statements=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.execute_statement.batch statements=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="batch_execute_statement",
        op_kwargs={"Statements": statements},
    )
