"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(hub, ctx, table_name: str, index_name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about contributor insights, for a given table or global secondary index.

    Args:
        table_name(str): The name of the table to describe.
        index_name(str, optional): The name of the global secondary index to describe, if applicable. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.contributor_insight.describe_all(ctx, table_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.contributor_insight.describe_all table_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="describe_contributor_insights",
        op_kwargs={"TableName": table_name, "IndexName": index_name},
    )


async def list_all(
    hub, ctx, table_name: str = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of ContributorInsightsSummary for a table and all its global secondary indexes.

    Args:
        table_name(str, optional): The name of the table. Defaults to None.
        next_token(str, optional): A token to for the desired page, if there is one. Defaults to None.
        max_results(int, optional): Maximum number of results to return per page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.contributor_insight.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.contributor_insight.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="list_contributor_insights",
        op_kwargs={
            "TableName": table_name,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update_multiple(
    hub, ctx, table_name: str, contributor_insights_action: str, index_name: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the status for contributor insights for a specific table or index.

    Args:
        table_name(str): The name of the table.
        index_name(str, optional): The global secondary index name, if applicable. Defaults to None.
        contributor_insights_action(str): Represents the contributor insights action.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.contributor_insight.update_multiple(
                ctx, table_name=value, contributor_insights_action=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.contributor_insight.update_multiple table_name=value, contributor_insights_action=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="update_contributor_insights",
        op_kwargs={
            "TableName": table_name,
            "IndexName": index_name,
            "ContributorInsightsAction": contributor_insights_action,
        },
    )
