"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(hub, ctx, table_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Checks the status of continuous backups and point in time recovery on the specified table. Continuous backups are ENABLED on all tables at table creation. If point in time recovery is enabled, PointInTimeRecoveryStatus will be set to ENABLED.  After continuous backups and point in time recovery are enabled, you can restore to any point in time within EarliestRestorableDateTime and LatestRestorableDateTime.   LatestRestorableDateTime is typically 5 minutes before the current time. You can restore your table to any point in time during the last 35 days.  You can call DescribeContinuousBackups at a maximum rate of 10 times per second.

    Args:
        table_name(str): Name of the table for which the customer wants to check the continuous backups and point in time recovery settings.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.continuous_backup.describe_all(ctx, table_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.continuous_backup.describe_all table_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="describe_continuous_backups",
        op_kwargs={"TableName": table_name},
    )


async def update_multiple(
    hub, ctx, table_name: str, point_in_time_recovery_specification: Dict
) -> Dict:
    r"""
    **Autogenerated function**

     UpdateContinuousBackups enables or disables point in time recovery for the specified table. A successful UpdateContinuousBackups call returns the current ContinuousBackupsDescription. Continuous backups are ENABLED on all tables at table creation. If point in time recovery is enabled, PointInTimeRecoveryStatus will be set to ENABLED.  Once continuous backups and point in time recovery are enabled, you can restore to any point in time within EarliestRestorableDateTime and LatestRestorableDateTime.   LatestRestorableDateTime is typically 5 minutes before the current time. You can restore your table to any point in time during the last 35 days.

    Args:
        table_name(str): The name of the table.
        point_in_time_recovery_specification(Dict): Represents the settings used to enable point in time recovery.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.continuous_backup.update_multiple(
                ctx, table_name=value, point_in_time_recovery_specification=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.continuous_backup.update_multiple table_name=value, point_in_time_recovery_specification=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="update_continuous_backups",
        op_kwargs={
            "TableName": table_name,
            "PointInTimeRecoverySpecification": point_in_time_recovery_specification,
        },
    )
