"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, table_name: str, backup_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates a backup for an existing table.  Each time you create an on-demand backup, the entire table data is backed up. There is no limit to the number of on-demand backups that can be taken.   When you create an on-demand backup, a time marker of the request is cataloged, and the backup is created asynchronously, by applying all changes until the time of the request to the last full table snapshot. Backup requests are processed instantaneously and become available for restore within minutes.  You can call CreateBackup at a maximum rate of 50 times per second. All backups in DynamoDB work without consuming any provisioned throughput on the table.  If you submit a backup request on 2018-12-14 at 14:25:00, the backup is guaranteed to contain all data committed to the table up to 14:24:00, and data committed after 14:26:00 will not be. The backup might contain data modifications made between 14:24:00 and 14:26:00. On-demand backup does not support causal consistency.   Along with data, the following are also included on the backups:    Global secondary indexes (GSIs)   Local secondary indexes (LSIs)   Streams   Provisioned read and write capacity

    Args:
        table_name(str): The name of the table.
        backup_name(str): Specified name for the backup.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.backup.create(ctx, table_name=value, backup_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.backup.create table_name=value, backup_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="create_backup",
        op_kwargs={"TableName": table_name, "BackupName": backup_name},
    )


async def delete(hub, ctx, backup_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an existing backup of a table. You can call DeleteBackup at a maximum rate of 10 times per second.

    Args:
        backup_arn(str): The ARN associated with the backup.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.backup.delete(ctx, backup_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.backup.delete backup_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="delete_backup",
        op_kwargs={"BackupArn": backup_arn},
    )


async def describe(hub, ctx, backup_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes an existing backup of a table. You can call DescribeBackup at a maximum rate of 10 times per second.

    Args:
        backup_arn(str): The Amazon Resource Name (ARN) associated with the backup.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.backup.describe(ctx, backup_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.backup.describe backup_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="describe_backup",
        op_kwargs={"BackupArn": backup_arn},
    )


async def list_all(
    hub,
    ctx,
    table_name: str = None,
    limit: int = None,
    time_range_lower_bound: str = None,
    time_range_upper_bound: str = None,
    exclusive_start_backup_arn: str = None,
    backup_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    List backups associated with an AWS account. To list backups for a given table, specify TableName. ListBackups returns a paginated list of results with at most 1 MB worth of items in a page. You can also specify a maximum number of entries to be returned in a page.  In the request, start time is inclusive, but end time is exclusive. Note that these boundaries are for the time at which the original backup was requested. You can call ListBackups a maximum of five times per second.

    Args:
        table_name(str, optional): The backups from the table specified by TableName are listed. . Defaults to None.
        limit(int, optional): Maximum number of backups to return at once. Defaults to None.
        time_range_lower_bound(str, optional): Only backups created after this time are listed. TimeRangeLowerBound is inclusive. Defaults to None.
        time_range_upper_bound(str, optional): Only backups created before this time are listed. TimeRangeUpperBound is exclusive. . Defaults to None.
        exclusive_start_backup_arn(str, optional):  LastEvaluatedBackupArn is the Amazon Resource Name (ARN) of the backup last evaluated when the current page of results was returned, inclusive of the current page of results. This value may be specified as the ExclusiveStartBackupArn of a new ListBackups operation in order to fetch the next page of results. . Defaults to None.
        backup_type(str, optional): The backups from the table specified by BackupType are listed. Where BackupType can be:    USER - On-demand backup created by you.    SYSTEM - On-demand backup automatically created by DynamoDB.    ALL - All types of on-demand backups (USER and SYSTEM).  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dynamodb.backup.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dynamodb.backup.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dynamodb",
        operation="list_backups",
        op_kwargs={
            "TableName": table_name,
            "Limit": limit,
            "TimeRangeLowerBound": time_range_lower_bound,
            "TimeRangeUpperBound": time_range_upper_bound,
            "ExclusiveStartBackupArn": exclusive_start_backup_arn,
            "BackupType": backup_type,
        },
    )
