"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def reset(hub, ctx, directory_id: str, user_name: str, new_password: str) -> Dict:
    r"""
    **Autogenerated function**

    Resets the password for any user in your AWS Managed Microsoft AD or Simple AD directory. You can reset the password for any user in your directory with the following exceptions:   For Simple AD, you cannot reset the password for any user that is a member of either the Domain Admins or Enterprise Admins group except for the administrator user.   For AWS Managed Microsoft AD, you can only reset the password for a user that is in an OU based off of the NetBIOS name that you typed when you created your directory. For example, you cannot reset the password for a user in the AWS Reserved OU. For more information about the OU structure for an AWS Managed Microsoft AD directory, see What Gets Created in the AWS Directory Service Administration Guide.

    Args:
        directory_id(str): Identifier of the AWS Managed Microsoft AD or Simple AD directory in which the user resides.
        user_name(str): The user name of the user whose password will be reset.
        new_password(str): The new password that will be reset.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.user_password.reset(
                ctx, directory_id=value, user_name=value, new_password=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.user_password.reset directory_id=value, user_name=value, new_password=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="reset_user_password",
        op_kwargs={
            "DirectoryId": directory_id,
            "UserName": user_name,
            "NewPassword": new_password,
        },
    )
