"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    directory_id: str,
    remote_domain_name: str,
    trust_password: str,
    trust_direction: str,
    trust_type: str = None,
    conditional_forwarder_ip_addrs: List = None,
    selective_auth: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    AWS Directory Service for Microsoft Active Directory allows you to configure trust relationships. For example, you can establish a trust between your AWS Managed Microsoft AD directory, and your existing on-premises Microsoft Active Directory. This would allow you to provide users and groups access to resources in either domain, with a single set of credentials. This action initiates the creation of the AWS side of a trust relationship between an AWS Managed Microsoft AD directory and an external domain. You can create either a forest trust or an external trust.

    Args:
        directory_id(str): The Directory ID of the AWS Managed Microsoft AD directory for which to establish the trust relationship.
        remote_domain_name(str): The Fully Qualified Domain Name (FQDN) of the external domain for which to create the trust relationship.
        trust_password(str): The trust password. The must be the same password that was used when creating the trust relationship on the external domain.
        trust_direction(str): The direction of the trust relationship.
        trust_type(str, optional): The trust relationship type. Forest is the default. Defaults to None.
        conditional_forwarder_ip_addrs(List, optional): The IP addresses of the remote DNS server associated with RemoteDomainName. Defaults to None.
        selective_auth(str, optional): Optional parameter to enable selective authentication for the trust. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.trust.create(
                ctx,
                directory_id=value,
                remote_domain_name=value,
                trust_password=value,
                trust_direction=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.trust.create directory_id=value, remote_domain_name=value, trust_password=value, trust_direction=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="create_trust",
        op_kwargs={
            "DirectoryId": directory_id,
            "RemoteDomainName": remote_domain_name,
            "TrustPassword": trust_password,
            "TrustDirection": trust_direction,
            "TrustType": trust_type,
            "ConditionalForwarderIpAddrs": conditional_forwarder_ip_addrs,
            "SelectiveAuth": selective_auth,
        },
    )


async def delete(
    hub, ctx, trust_id: str, delete_associated_conditional_forwarder: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an existing trust relationship between your AWS Managed Microsoft AD directory and an external domain.

    Args:
        trust_id(str): The Trust ID of the trust relationship to be deleted.
        delete_associated_conditional_forwarder(bool, optional): Delete a conditional forwarder as part of a DeleteTrustRequest. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.trust.delete(ctx, trust_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.trust.delete trust_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="delete_trust",
        op_kwargs={
            "TrustId": trust_id,
            "DeleteAssociatedConditionalForwarder": delete_associated_conditional_forwarder,
        },
    )


async def describe_all(
    hub,
    ctx,
    directory_id: str = None,
    trust_ids: List = None,
    next_token: str = None,
    limit: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Obtains information about the trust relationships for this account. If no input parameters are provided, such as DirectoryId or TrustIds, this request describes all the trust relationships belonging to the account.

    Args:
        directory_id(str, optional): The Directory ID of the AWS directory that is a part of the requested trust relationship. Defaults to None.
        trust_ids(List, optional): A list of identifiers of the trust relationships for which to obtain the information. If this member is null, all trust relationships that belong to the current account are returned. An empty list results in an InvalidParameterException being thrown. Defaults to None.
        next_token(str, optional): The DescribeTrustsResult.NextToken value from a previous call to DescribeTrusts. Pass null if this is the first call. Defaults to None.
        limit(int, optional): The maximum number of objects to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.trust.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.trust.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="describe_trusts",
        op_kwargs={
            "DirectoryId": directory_id,
            "TrustIds": trust_ids,
            "NextToken": next_token,
            "Limit": limit,
        },
    )


async def update(hub, ctx, trust_id: str, selective_auth: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates the trust that has been set up between your AWS Managed Microsoft AD directory and an on-premises Active Directory.

    Args:
        trust_id(str): Identifier of the trust relationship.
        selective_auth(str, optional): Updates selective authentication for the trust. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.trust.update(ctx, trust_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.trust.update trust_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="update_trust",
        op_kwargs={"TrustId": trust_id, "SelectiveAuth": selective_auth},
    )


async def verify(hub, ctx, trust_id: str) -> Dict:
    r"""
    **Autogenerated function**

    AWS Directory Service for Microsoft Active Directory allows you to configure and verify trust relationships. This action verifies a trust relationship between your AWS Managed Microsoft AD directory and an external domain.

    Args:
        trust_id(str): The unique Trust ID of the trust relationship to verify.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.trust.verify(ctx, trust_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.trust.verify trust_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="verify_trust",
        op_kwargs={"TrustId": trust_id},
    )
