"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def add(hub, ctx, resource_id: str, tags: List) -> Dict:
    r"""
    **Autogenerated function**

    Adds or overwrites one or more tags for the specified directory. Each directory can have a maximum of 50 tags. Each tag consists of a key and optional value. Tag keys must be unique to each resource.

    Args:
        resource_id(str): Identifier (ID) for the directory to which to add the tag.
        tags(List): The tags to be assigned to the directory.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.tags.to_resource.add(ctx, resource_id=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.tags.to_resource.add resource_id=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="add_tags_to_resource",
        op_kwargs={"ResourceId": resource_id, "Tags": tags},
    )
