"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def remove(hub, ctx, resource_id: str, tag_keys: List) -> Dict:
    r"""
    **Autogenerated function**

    Removes tags from a directory.

    Args:
        resource_id(str): Identifier (ID) of the directory from which to remove the tag.
        tag_keys(List): The tag key (name) of the tag to be removed.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.tags.from_resource.remove(
                ctx, resource_id=value, tag_keys=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.tags.from_resource.remove resource_id=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="remove_tags_from_resource",
        op_kwargs={"ResourceId": resource_id, "TagKeys": tag_keys},
    )
