"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disable(
    hub, ctx, directory_id: str, user_name: str = None, password: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Disables single-sign on for a directory.

    Args:
        directory_id(str): The identifier of the directory for which to disable single-sign on.
        user_name(str, optional): The username of an alternate account to use to disable single-sign on. This is only used for AD Connector directories. This account must have privileges to remove a service principal name. If the AD Connector service account does not have privileges to remove a service principal name, you can specify an alternate account with the UserName and Password parameters. These credentials are only used to disable single sign-on and are not stored by the service. The AD Connector service account is not changed. Defaults to None.
        password(str, optional): The password of an alternate account to use to disable single-sign on. This is only used for AD Connector directories. For more information, see the UserName parameter. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.sso.disable(ctx, directory_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.sso.disable directory_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="disable_sso",
        op_kwargs={
            "DirectoryId": directory_id,
            "UserName": user_name,
            "Password": password,
        },
    )


async def enable(
    hub, ctx, directory_id: str, user_name: str = None, password: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Enables single sign-on for a directory. Single sign-on allows users in your directory to access certain AWS services from a computer joined to the directory without having to enter their credentials separately.

    Args:
        directory_id(str): The identifier of the directory for which to enable single-sign on.
        user_name(str, optional): The username of an alternate account to use to enable single-sign on. This is only used for AD Connector directories. This account must have privileges to add a service principal name. If the AD Connector service account does not have privileges to add a service principal name, you can specify an alternate account with the UserName and Password parameters. These credentials are only used to enable single sign-on and are not stored by the service. The AD Connector service account is not changed. Defaults to None.
        password(str, optional): The password of an alternate account to use to enable single-sign on. This is only used for AD Connector directories. For more information, see the UserName parameter. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.sso.enable(ctx, directory_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.sso.enable directory_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="enable_sso",
        op_kwargs={
            "DirectoryId": directory_id,
            "UserName": user_name,
            "Password": password,
        },
    )
