"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, directory_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Obtains the manual snapshot limits for a directory.

    Args:
        directory_id(str): Contains the identifier of the directory to obtain the limits for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.snapshot.limit.get_all(ctx, directory_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.snapshot.limit.get_all directory_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="get_snapshot_limits",
        op_kwargs={"DirectoryId": directory_id},
    )
