"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, directory_id: str, name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates a snapshot of a Simple AD or Microsoft AD directory in the AWS cloud.  You cannot take snapshots of AD Connector directories.

    Args:
        directory_id(str): The identifier of the directory of which to take a snapshot.
        name(str, optional): The descriptive name to apply to the snapshot. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.snapshot.init.create(ctx, directory_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.snapshot.init.create directory_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="create_snapshot",
        op_kwargs={"DirectoryId": directory_id, "Name": name},
    )


async def delete(hub, ctx, snapshot_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a directory snapshot.

    Args:
        snapshot_id(str): The identifier of the directory snapshot to be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.snapshot.init.delete(ctx, snapshot_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.snapshot.init.delete snapshot_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="delete_snapshot",
        op_kwargs={"SnapshotId": snapshot_id},
    )


async def describe_all(
    hub,
    ctx,
    directory_id: str = None,
    snapshot_ids: List = None,
    next_token: str = None,
    limit: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Obtains information about the directory snapshots that belong to this account. This operation supports pagination with the use of the NextToken request and response parameters. If more results are available, the DescribeSnapshots.NextToken member contains a token that you pass in the next call to DescribeSnapshots to retrieve the next set of items. You can also specify a maximum number of return results with the Limit parameter.

    Args:
        directory_id(str, optional): The identifier of the directory for which to retrieve snapshot information. Defaults to None.
        snapshot_ids(List, optional): A list of identifiers of the snapshots to obtain the information for. If this member is null or empty, all snapshots are returned using the Limit and NextToken members. Defaults to None.
        next_token(str, optional): The DescribeSnapshotsResult.NextToken value from a previous call to DescribeSnapshots. Pass null if this is the first call. Defaults to None.
        limit(int, optional): The maximum number of objects to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.snapshot.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.snapshot.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="describe_snapshots",
        op_kwargs={
            "DirectoryId": directory_id,
            "SnapshotIds": snapshot_ids,
            "NextToken": next_token,
            "Limit": limit,
        },
    )
