"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def accept(hub, ctx, shared_directory_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Accepts a directory sharing request that was sent from the directory owner account.

    Args:
        shared_directory_id(str): Identifier of the shared directory in the directory consumer account. This identifier is different for each directory owner account. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.shared_directory.accept(ctx, shared_directory_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.shared_directory.accept shared_directory_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="accept_shared_directory",
        op_kwargs={"SharedDirectoryId": shared_directory_id},
    )


async def describe_all(
    hub,
    ctx,
    owner_directory_id: str,
    shared_directory_ids: List = None,
    next_token: str = None,
    limit: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the shared directories in your account.

    Args:
        owner_directory_id(str): Returns the identifier of the directory in the directory owner account. .
        shared_directory_ids(List, optional): A list of identifiers of all shared directories in your account. . Defaults to None.
        next_token(str, optional): The DescribeSharedDirectoriesResult.NextToken value from a previous call to DescribeSharedDirectories. Pass null if this is the first call. . Defaults to None.
        limit(int, optional): The number of shared directories to return in the response object. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.shared_directory.describe_all(ctx, owner_directory_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.shared_directory.describe_all owner_directory_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="describe_shared_directories",
        op_kwargs={
            "OwnerDirectoryId": owner_directory_id,
            "SharedDirectoryIds": shared_directory_ids,
            "NextToken": next_token,
            "Limit": limit,
        },
    )


async def reject(hub, ctx, shared_directory_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Rejects a directory sharing request that was sent from the directory owner account.

    Args:
        shared_directory_id(str): Identifier of the shared directory in the directory consumer account. This identifier is different for each directory owner account.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.shared_directory.reject(ctx, shared_directory_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.shared_directory.reject shared_directory_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="reject_shared_directory",
        op_kwargs={"SharedDirectoryId": shared_directory_id},
    )
