"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def cancel(hub, ctx, directory_id: str, schema_extension_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Cancels an in-progress schema extension to a Microsoft AD directory. Once a schema extension has started replicating to all domain controllers, the task can no longer be canceled. A schema extension can be canceled during any of the following states; Initializing, CreatingSnapshot, and UpdatingSchema.

    Args:
        directory_id(str): The identifier of the directory whose schema extension will be canceled.
        schema_extension_id(str): The identifier of the schema extension that will be canceled.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.schema_extension.cancel(
                ctx, directory_id=value, schema_extension_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.schema_extension.cancel directory_id=value, schema_extension_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="cancel_schema_extension",
        op_kwargs={
            "DirectoryId": directory_id,
            "SchemaExtensionId": schema_extension_id,
        },
    )


async def list_all(
    hub, ctx, directory_id: str, next_token: str = None, limit: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all schema extensions applied to a Microsoft AD Directory.

    Args:
        directory_id(str): The identifier of the directory from which to retrieve the schema extension information.
        next_token(str, optional): The ListSchemaExtensions.NextToken value from a previous call to ListSchemaExtensions. Pass null if this is the first call. Defaults to None.
        limit(int, optional): The maximum number of items to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.schema_extension.list_all(ctx, directory_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.schema_extension.list_all directory_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="list_schema_extensions",
        op_kwargs={
            "DirectoryId": directory_id,
            "NextToken": next_token,
            "Limit": limit,
        },
    )


async def start(
    hub,
    ctx,
    directory_id: str,
    create_snapshot_before_schema_extension: bool,
    ldif_content: str,
    description: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Applies a schema extension to a Microsoft AD directory.

    Args:
        directory_id(str): The identifier of the directory for which the schema extension will be applied to.
        create_snapshot_before_schema_extension(bool): If true, creates a snapshot of the directory before applying the schema extension.
        ldif_content(str): The LDIF file represented as a string. To construct the LdifContent string, precede each line as it would be formatted in an ldif file with \n. See the example request below for more details. The file size can be no larger than 1MB.
        description(str): A description of the schema extension.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.schema_extension.start(
                ctx,
                directory_id=value,
                create_snapshot_before_schema_extension=value,
                ldif_content=value,
                description=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.schema_extension.start directory_id=value, create_snapshot_before_schema_extension=value, ldif_content=value, description=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="start_schema_extension",
        op_kwargs={
            "DirectoryId": directory_id,
            "CreateSnapshotBeforeSchemaExtension": create_snapshot_before_schema_extension,
            "LdifContent": ldif_content,
            "Description": description,
        },
    )
