"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def add(
    hub, ctx, directory_id: str, region_name: str, vpc_settings: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Adds two domain controllers in the specified Region for the specified directory.

    Args:
        directory_id(str): The identifier of the directory to which you want to add Region replication.
        region_name(str): The name of the Region where you want to add domain controllers for replication. For example, us-east-1.
        vpc_settings(Dict): Contains VPC information for the CreateDirectory or CreateMicrosoftAD operation.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.region.add(
                ctx, directory_id=value, region_name=value, vpc_settings=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.region.add directory_id=value, region_name=value, vpc_settings=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="add_region",
        op_kwargs={
            "DirectoryId": directory_id,
            "RegionName": region_name,
            "VPCSettings": vpc_settings,
        },
    )


async def describe_all(
    hub, ctx, directory_id: str, region_name: str = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Provides information about the Regions that are configured for multi-Region replication.

    Args:
        directory_id(str): The identifier of the directory.
        region_name(str, optional): The name of the Region. For example, us-east-1. Defaults to None.
        next_token(str, optional): The DescribeRegionsResult.NextToken value from a previous call to DescribeRegions. Pass null if this is the first call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.region.describe_all(ctx, directory_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.region.describe_all directory_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="describe_regions",
        op_kwargs={
            "DirectoryId": directory_id,
            "RegionName": region_name,
            "NextToken": next_token,
        },
    )


async def remove(hub, ctx, directory_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops all replication and removes the domain controllers from the specified Region. You cannot remove the primary Region with this operation. Instead, use the DeleteDirectory API.

    Args:
        directory_id(str): The identifier of the directory for which you want to remove Region replication.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.region.remove(ctx, directory_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.region.remove directory_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="remove_region",
        op_kwargs={"DirectoryId": directory_id},
    )
