"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disable(hub, ctx, directory_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Disables multi-factor authentication (MFA) with the Remote Authentication Dial In User Service (RADIUS) server for an AD Connector or Microsoft AD directory.

    Args:
        directory_id(str): The identifier of the directory for which to disable MFA.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.radius.disable(ctx, directory_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.radius.disable directory_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="disable_radius",
        op_kwargs={"DirectoryId": directory_id},
    )


async def enable(hub, ctx, directory_id: str, radius_settings: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Enables multi-factor authentication (MFA) with the Remote Authentication Dial In User Service (RADIUS) server for an AD Connector or Microsoft AD directory.

    Args:
        directory_id(str): The identifier of the directory for which to enable MFA.
        radius_settings(Dict): A RadiusSettings object that contains information about the RADIUS server.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.radius.enable(ctx, directory_id=value, radius_settings=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.radius.enable directory_id=value, radius_settings=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="enable_radius",
        op_kwargs={"DirectoryId": directory_id, "RadiusSettings": radius_settings},
    )


async def update(hub, ctx, directory_id: str, radius_settings: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Updates the Remote Authentication Dial In User Service (RADIUS) server information for an AD Connector or Microsoft AD directory.

    Args:
        directory_id(str): The identifier of the directory for which to update the RADIUS server information.
        radius_settings(Dict): A RadiusSettings object that contains information about the RADIUS server.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.radius.update(ctx, directory_id=value, radius_settings=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.radius.update directory_id=value, radius_settings=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="update_radius",
        op_kwargs={"DirectoryId": directory_id, "RadiusSettings": radius_settings},
    )
