"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update_multiple(hub, ctx, directory_id: str, desired_number: int) -> Dict:
    r"""
    **Autogenerated function**

    Adds or removes domain controllers to or from the directory. Based on the difference between current value and new value (provided through this API call), domain controllers will be added or removed. It may take up to 45 minutes for any new domain controllers to become fully active once the requested number of domain controllers is updated. During this time, you cannot make another update request.

    Args:
        directory_id(str): Identifier of the directory to which the domain controllers will be added or removed.
        desired_number(int): The number of domain controllers desired in the directory.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.number_of_domain_controller.update_multiple(
                ctx, directory_id=value, desired_number=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.number_of_domain_controller.update_multiple directory_id=value, desired_number=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="update_number_of_domain_controllers",
        op_kwargs={"DirectoryId": directory_id, "DesiredNumber": desired_number},
    )
