"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    password: str,
    vpc_settings: Dict,
    short_name: str = None,
    description: str = None,
    edition: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Microsoft AD directory in the AWS Cloud. For more information, see AWS Managed Microsoft AD in the AWS Directory Service Admin Guide. Before you call CreateMicrosoftAD, ensure that all of the required permissions have been explicitly granted through a policy. For details about what permissions are required to run the CreateMicrosoftAD operation, see AWS Directory Service API Permissions: Actions, Resources, and Conditions Reference.

    Args:
        name(str): The fully qualified domain name for the AWS Managed Microsoft AD directory, such as corp.example.com. This name will resolve inside your VPC only. It does not need to be publicly resolvable.
        short_name(str, optional): The NetBIOS name for your domain, such as CORP. If you don't specify a NetBIOS name, it will default to the first part of your directory DNS. For example, CORP for the directory DNS corp.example.com. . Defaults to None.
        password(str): The password for the default administrative user named Admin. If you need to change the password for the administrator account, you can use the ResetUserPassword API call.
        description(str, optional): A description for the directory. This label will appear on the AWS console Directory Details page after the directory is created. Defaults to None.
        vpc_settings(Dict): Contains VPC information for the CreateDirectory or CreateMicrosoftAD operation.
        edition(str, optional): AWS Managed Microsoft AD is available in two editions: Standard and Enterprise. Enterprise is the default. Defaults to None.
        tags(List, optional): The tags to be assigned to the AWS Managed Microsoft AD directory. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.microsoft_ad.create(
                ctx, name=value, password=value, vpc_settings=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.microsoft_ad.create name=value, password=value, vpc_settings=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="create_microsoft_ad",
        op_kwargs={
            "Name": name,
            "ShortName": short_name,
            "Password": password,
            "Description": description,
            "VpcSettings": vpc_settings,
            "Edition": edition,
            "Tags": tags,
        },
    )
