"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, directory_id: str, log_group_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates a subscription to forward real-time Directory Service domain controller security logs to the specified Amazon CloudWatch log group in your AWS account.

    Args:
        directory_id(str): Identifier of the directory to which you want to subscribe and receive real-time logs to your specified CloudWatch log group.
        log_group_name(str): The name of the CloudWatch log group where the real-time domain controller logs are forwarded.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.log_subscription.create(
                ctx, directory_id=value, log_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.log_subscription.create directory_id=value, log_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="create_log_subscription",
        op_kwargs={"DirectoryId": directory_id, "LogGroupName": log_group_name},
    )


async def delete(hub, ctx, directory_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified log subscription.

    Args:
        directory_id(str): Identifier of the directory whose log subscription you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.log_subscription.delete(ctx, directory_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.log_subscription.delete directory_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="delete_log_subscription",
        op_kwargs={"DirectoryId": directory_id},
    )


async def list_all(
    hub, ctx, directory_id: str = None, next_token: str = None, limit: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the active log subscriptions for the AWS account.

    Args:
        directory_id(str, optional): If a DirectoryID is provided, lists only the log subscription associated with that directory. If no DirectoryId is provided, lists all log subscriptions associated with your AWS account. If there are no log subscriptions for the AWS account or the directory, an empty list will be returned. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. Defaults to None.
        limit(int, optional): The maximum number of items returned. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.log_subscription.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.log_subscription.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="list_log_subscriptions",
        op_kwargs={
            "DirectoryId": directory_id,
            "NextToken": next_token,
            "Limit": limit,
        },
    )
