"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    directory_id: str,
    type_: str = None,
    next_token: str = None,
    limit: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the status of LDAP security for the specified directory.

    Args:
        directory_id(str): The identifier of the directory.
        type_(str, optional): The type of LDAP security to enable. Currently only the value Client is supported. Defaults to None.
        next_token(str, optional): The type of next token used for pagination. Defaults to None.
        limit(int, optional): Specifies the number of items that should be displayed on one page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.ldap.setting.describe_all(ctx, directory_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.ldap.setting.describe_all directory_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="describe_ldaps_settings",
        op_kwargs={
            "DirectoryId": directory_id,
            "Type": type_,
            "NextToken": next_token,
            "Limit": limit,
        },
    )
