"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disable(hub, ctx, directory_id: str, type_: str) -> Dict:
    r"""
    **Autogenerated function**

    Deactivates LDAP secure calls for the specified directory.

    Args:
        directory_id(str): The identifier of the directory.
        type_(str): The type of LDAP security to enable. Currently only the value Client is supported.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.ldap.init.disable(ctx, directory_id=value, type_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.ldap.init.disable directory_id=value, type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="disable_ldaps",
        op_kwargs={"DirectoryId": directory_id, "Type": type_},
    )


async def enable(hub, ctx, directory_id: str, type_: str) -> Dict:
    r"""
    **Autogenerated function**

    Activates the switch for the specific directory to always use LDAP secure calls.

    Args:
        directory_id(str): The identifier of the directory.
        type_(str): The type of LDAP security to enable. Currently only the value Client is supported.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.ldap.init.enable(ctx, directory_id=value, type_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.ldap.init.enable directory_id=value, type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="enable_ldaps",
        op_kwargs={"DirectoryId": directory_id, "Type": type_},
    )
