"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def add(
    hub,
    ctx,
    directory_id: str,
    ip_routes: List,
    update_security_group_for_directory_controllers: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    If the DNS server for your on-premises domain uses a publicly addressable IP address, you must add a CIDR address block to correctly route traffic to and from your Microsoft AD on Amazon Web Services. AddIpRoutes adds this address block. You can also use AddIpRoutes to facilitate routing traffic that uses public IP ranges from your Microsoft AD on AWS to a peer VPC.  Before you call AddIpRoutes, ensure that all of the required permissions have been explicitly granted through a policy. For details about what permissions are required to run the AddIpRoutes operation, see AWS Directory Service API Permissions: Actions, Resources, and Conditions Reference.

    Args:
        directory_id(str): Identifier (ID) of the directory to which to add the address block.
        ip_routes(List): IP address blocks, using CIDR format, of the traffic to route. This is often the IP address block of the DNS server used for your on-premises domain.
        update_security_group_for_directory_controllers(bool, optional): If set to true, updates the inbound and outbound rules of the security group that has the description: "AWS created security group for directory ID directory controllers." Following are the new rules:  Inbound:   Type: Custom UDP Rule, Protocol: UDP, Range: 88, Source: 0.0.0.0/0   Type: Custom UDP Rule, Protocol: UDP, Range: 123, Source: 0.0.0.0/0   Type: Custom UDP Rule, Protocol: UDP, Range: 138, Source: 0.0.0.0/0   Type: Custom UDP Rule, Protocol: UDP, Range: 389, Source: 0.0.0.0/0   Type: Custom UDP Rule, Protocol: UDP, Range: 464, Source: 0.0.0.0/0   Type: Custom UDP Rule, Protocol: UDP, Range: 445, Source: 0.0.0.0/0   Type: Custom TCP Rule, Protocol: TCP, Range: 88, Source: 0.0.0.0/0   Type: Custom TCP Rule, Protocol: TCP, Range: 135, Source: 0.0.0.0/0   Type: Custom TCP Rule, Protocol: TCP, Range: 445, Source: 0.0.0.0/0   Type: Custom TCP Rule, Protocol: TCP, Range: 464, Source: 0.0.0.0/0   Type: Custom TCP Rule, Protocol: TCP, Range: 636, Source: 0.0.0.0/0   Type: Custom TCP Rule, Protocol: TCP, Range: 1024-65535, Source: 0.0.0.0/0   Type: Custom TCP Rule, Protocol: TCP, Range: 3268-33269, Source: 0.0.0.0/0   Type: DNS (UDP), Protocol: UDP, Range: 53, Source: 0.0.0.0/0   Type: DNS (TCP), Protocol: TCP, Range: 53, Source: 0.0.0.0/0   Type: LDAP, Protocol: TCP, Range: 389, Source: 0.0.0.0/0   Type: All ICMP, Protocol: All, Range: N/A, Source: 0.0.0.0/0    Outbound:   Type: All traffic, Protocol: All, Range: All, Destination: 0.0.0.0/0   These security rules impact an internal network interface that is not exposed publicly. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.ip_route.add(ctx, directory_id=value, ip_routes=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.ip_route.add directory_id=value, ip_routes=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="add_ip_routes",
        op_kwargs={
            "DirectoryId": directory_id,
            "IpRoutes": ip_routes,
            "UpdateSecurityGroupForDirectoryControllers": update_security_group_for_directory_controllers,
        },
    )


async def list_all(
    hub, ctx, directory_id: str, next_token: str = None, limit: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the address blocks that you have added to a directory.

    Args:
        directory_id(str): Identifier (ID) of the directory for which you want to retrieve the IP addresses.
        next_token(str, optional): The ListIpRoutes.NextToken value from a previous call to ListIpRoutes. Pass null if this is the first call. Defaults to None.
        limit(int, optional): Maximum number of items to return. If this value is zero, the maximum number of items is specified by the limitations of the operation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.ip_route.list_all(ctx, directory_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.ip_route.list_all directory_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="list_ip_routes",
        op_kwargs={
            "DirectoryId": directory_id,
            "NextToken": next_token,
            "Limit": limit,
        },
    )


async def remove(hub, ctx, directory_id: str, cidr_ips: List) -> Dict:
    r"""
    **Autogenerated function**

    Removes IP address blocks from a directory.

    Args:
        directory_id(str): Identifier (ID) of the directory from which you want to remove the IP addresses.
        cidr_ips(List): IP address blocks that you want to remove.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.ip_route.remove(ctx, directory_id=value, cidr_ips=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.ip_route.remove directory_id=value, cidr_ips=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="remove_ip_routes",
        op_kwargs={"DirectoryId": directory_id, "CidrIps": cidr_ips},
    )
