"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def deregister(hub, ctx, directory_id: str, topic_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes the specified directory as a publisher to the specified SNS topic.

    Args:
        directory_id(str): The Directory ID to remove as a publisher. This directory will no longer send messages to the specified SNS topic.
        topic_name(str): The name of the SNS topic from which to remove the directory as a publisher.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.event_topic.deregister(
                ctx, directory_id=value, topic_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.event_topic.deregister directory_id=value, topic_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="deregister_event_topic",
        op_kwargs={"DirectoryId": directory_id, "TopicName": topic_name},
    )


async def describe_all(
    hub, ctx, directory_id: str = None, topic_names: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Obtains information about which SNS topics receive status messages from the specified directory. If no input parameters are provided, such as DirectoryId or TopicName, this request describes all of the associations in the account.

    Args:
        directory_id(str, optional): The Directory ID for which to get the list of associated SNS topics. If this member is null, associations for all Directory IDs are returned. Defaults to None.
        topic_names(List, optional): A list of SNS topic names for which to obtain the information. If this member is null, all associations for the specified Directory ID are returned. An empty list results in an InvalidParameterException being thrown. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.event_topic.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.event_topic.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="describe_event_topics",
        op_kwargs={"DirectoryId": directory_id, "TopicNames": topic_names},
    )


async def register(hub, ctx, directory_id: str, topic_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Associates a directory with an SNS topic. This establishes the directory as a publisher to the specified SNS topic. You can then receive email or text (SMS) messages when the status of your directory changes. You get notified if your directory goes from an Active status to an Impaired or Inoperable status. You also receive a notification when the directory returns to an Active status.

    Args:
        directory_id(str): The Directory ID that will publish status messages to the SNS topic.
        topic_name(str): The SNS topic name to which the directory will publish status messages. This SNS topic must be in the same region as the specified Directory ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.event_topic.register(
                ctx, directory_id=value, topic_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.event_topic.register directory_id=value, topic_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="register_event_topic",
        op_kwargs={"DirectoryId": directory_id, "TopicName": topic_name},
    )
