"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    directory_id: str,
    domain_controller_ids: List = None,
    next_token: str = None,
    limit: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Provides information about any domain controllers in your directory.

    Args:
        directory_id(str): Identifier of the directory for which to retrieve the domain controller information.
        domain_controller_ids(List, optional): A list of identifiers for the domain controllers whose information will be provided. Defaults to None.
        next_token(str, optional): The DescribeDomainControllers.NextToken value from a previous call to DescribeDomainControllers. Pass null if this is the first call. . Defaults to None.
        limit(int, optional): The maximum number of items to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.domain_controller.describe_all(ctx, directory_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.domain_controller.describe_all directory_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="describe_domain_controllers",
        op_kwargs={
            "DirectoryId": directory_id,
            "DomainControllerIds": domain_controller_ids,
            "NextToken": next_token,
            "Limit": limit,
        },
    )
