"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def connect(
    hub,
    ctx,
    name: str,
    password: str,
    size: str,
    connect_settings: Dict,
    short_name: str = None,
    description: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an AD Connector to connect to an on-premises directory. Before you call ConnectDirectory, ensure that all of the required permissions have been explicitly granted through a policy. For details about what permissions are required to run the ConnectDirectory operation, see AWS Directory Service API Permissions: Actions, Resources, and Conditions Reference.

    Args:
        name(str): The fully qualified name of the on-premises directory, such as corp.example.com.
        short_name(str, optional): The NetBIOS name of the on-premises directory, such as CORP. Defaults to None.
        password(str): The password for the on-premises user account.
        description(str, optional): A description for the directory. Defaults to None.
        size(str): The size of the directory.
        connect_settings(Dict): A DirectoryConnectSettings object that contains additional information for the operation.
        tags(List, optional): The tags to be assigned to AD Connector. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.directory.init.connect(
                ctx, name=value, password=value, size=value, connect_settings=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.directory.init.connect name=value, password=value, size=value, connect_settings=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="connect_directory",
        op_kwargs={
            "Name": name,
            "ShortName": short_name,
            "Password": password,
            "Description": description,
            "Size": size,
            "ConnectSettings": connect_settings,
            "Tags": tags,
        },
    )


async def create(
    hub,
    ctx,
    name: str,
    password: str,
    size: str,
    short_name: str = None,
    description: str = None,
    vpc_settings: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Simple AD directory. For more information, see Simple Active Directory in the AWS Directory Service Admin Guide. Before you call CreateDirectory, ensure that all of the required permissions have been explicitly granted through a policy. For details about what permissions are required to run the CreateDirectory operation, see AWS Directory Service API Permissions: Actions, Resources, and Conditions Reference.

    Args:
        name(str): The fully qualified name for the directory, such as corp.example.com.
        short_name(str, optional): The NetBIOS name of the directory, such as CORP. Defaults to None.
        password(str): The password for the directory administrator. The directory creation process creates a directory administrator account with the user name Administrator and this password. If you need to change the password for the administrator account, you can use the ResetUserPassword API call. The regex pattern for this string is made up of the following conditions:   Length (?=^.{8,64}$) – Must be between 8 and 64 characters   AND any 3 of the following password complexity rules required by Active Directory:   Numbers and upper case and lowercase (?=.*\d)(?=.*[A-Z])(?=.*[a-z])   Numbers and special characters and lower case (?=.*\d)(?=.*[^A-Za-z0-9\s])(?=.*[a-z])   Special characters and upper case and lower case (?=.*[^A-Za-z0-9\s])(?=.*[A-Z])(?=.*[a-z])   Numbers and upper case and special characters (?=.*\d)(?=.*[A-Z])(?=.*[^A-Za-z0-9\s])   For additional information about how Active Directory passwords are enforced, see Password must meet complexity requirements on the Microsoft website.
        description(str, optional): A description for the directory. Defaults to None.
        size(str): The size of the directory.
        vpc_settings(Dict, optional): A DirectoryVpcSettings object that contains additional information for the operation. Defaults to None.
        tags(List, optional): The tags to be assigned to the Simple AD directory. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.directory.init.create(
                ctx, name=value, password=value, size=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.directory.init.create name=value, password=value, size=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="create_directory",
        op_kwargs={
            "Name": name,
            "ShortName": short_name,
            "Password": password,
            "Description": description,
            "Size": size,
            "VpcSettings": vpc_settings,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, directory_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an AWS Directory Service directory. Before you call DeleteDirectory, ensure that all of the required permissions have been explicitly granted through a policy. For details about what permissions are required to run the DeleteDirectory operation, see AWS Directory Service API Permissions: Actions, Resources, and Conditions Reference.

    Args:
        directory_id(str): The identifier of the directory to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.directory.init.delete(ctx, directory_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.directory.init.delete directory_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="delete_directory",
        op_kwargs={"DirectoryId": directory_id},
    )


async def describe_all(
    hub, ctx, directory_ids: List = None, next_token: str = None, limit: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Obtains information about the directories that belong to this account. You can retrieve information about specific directories by passing the directory identifiers in the DirectoryIds parameter. Otherwise, all directories that belong to the current account are returned. This operation supports pagination with the use of the NextToken request and response parameters. If more results are available, the DescribeDirectoriesResult.NextToken member contains a token that you pass in the next call to DescribeDirectories to retrieve the next set of items. You can also specify a maximum number of return results with the Limit parameter.

    Args:
        directory_ids(List, optional): A list of identifiers of the directories for which to obtain the information. If this member is null, all directories that belong to the current account are returned. An empty list results in an InvalidParameterException being thrown. Defaults to None.
        next_token(str, optional): The DescribeDirectoriesResult.NextToken value from a previous call to DescribeDirectories. Pass null if this is the first call. Defaults to None.
        limit(int, optional): The maximum number of items to return. If this value is zero, the maximum number of items is specified by the limitations of the operation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.directory.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.directory.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="describe_directories",
        op_kwargs={
            "DirectoryIds": directory_ids,
            "NextToken": next_token,
            "Limit": limit,
        },
    )


async def share(
    hub,
    ctx,
    directory_id: str,
    share_target: Dict,
    share_method: str,
    share_notes: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Shares a specified directory (DirectoryId) in your AWS account (directory owner) with another AWS account (directory consumer). With this operation you can use your directory from any AWS account and from any Amazon VPC within an AWS Region. When you share your AWS Managed Microsoft AD directory, AWS Directory Service creates a shared directory in the directory consumer account. This shared directory contains the metadata to provide access to the directory within the directory owner account. The shared directory is visible in all VPCs in the directory consumer account. The ShareMethod parameter determines whether the specified directory can be shared between AWS accounts inside the same AWS organization (ORGANIZATIONS). It also determines whether you can share the directory with any other AWS account either inside or outside of the organization (HANDSHAKE). The ShareNotes parameter is only used when HANDSHAKE is called, which sends a directory sharing request to the directory consumer.

    Args:
        directory_id(str): Identifier of the AWS Managed Microsoft AD directory that you want to share with other AWS accounts.
        share_notes(str, optional): A directory share request that is sent by the directory owner to the directory consumer. The request includes a typed message to help the directory consumer administrator determine whether to approve or reject the share invitation. Defaults to None.
        share_target(Dict): Identifier for the directory consumer account with whom the directory is to be shared.
        share_method(str): The method used when sharing a directory to determine whether the directory should be shared within your AWS organization (ORGANIZATIONS) or with any AWS account by sending a directory sharing request (HANDSHAKE).

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.directory.init.share(
                ctx, directory_id=value, share_target=value, share_method=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.directory.init.share directory_id=value, share_target=value, share_method=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="share_directory",
        op_kwargs={
            "DirectoryId": directory_id,
            "ShareNotes": share_notes,
            "ShareTarget": share_target,
            "ShareMethod": share_method,
        },
    )


async def unshare(hub, ctx, directory_id: str, unshare_target: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Stops the directory sharing between the directory owner and consumer accounts.

    Args:
        directory_id(str): The identifier of the AWS Managed Microsoft AD directory that you want to stop sharing.
        unshare_target(Dict): Identifier for the directory consumer account with whom the directory has to be unshared.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.directory.init.unshare(
                ctx, directory_id=value, unshare_target=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.directory.init.unshare directory_id=value, unshare_target=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="unshare_directory",
        op_kwargs={"DirectoryId": directory_id, "UnshareTarget": unshare_target},
    )
