"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, directory_id: str, remote_domain_name: str, dns_ip_addrs: List
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a conditional forwarder associated with your AWS directory. Conditional forwarders are required in order to set up a trust relationship with another domain. The conditional forwarder points to the trusted domain.

    Args:
        directory_id(str): The directory ID of the AWS directory for which you are creating the conditional forwarder.
        remote_domain_name(str): The fully qualified domain name (FQDN) of the remote domain with which you will set up a trust relationship.
        dns_ip_addrs(List): The IP addresses of the remote DNS server associated with RemoteDomainName.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.conditional_forwarder.create(
                ctx, directory_id=value, remote_domain_name=value, dns_ip_addrs=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.conditional_forwarder.create directory_id=value, remote_domain_name=value, dns_ip_addrs=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="create_conditional_forwarder",
        op_kwargs={
            "DirectoryId": directory_id,
            "RemoteDomainName": remote_domain_name,
            "DnsIpAddrs": dns_ip_addrs,
        },
    )


async def delete(hub, ctx, directory_id: str, remote_domain_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a conditional forwarder that has been set up for your AWS directory.

    Args:
        directory_id(str): The directory ID for which you are deleting the conditional forwarder.
        remote_domain_name(str): The fully qualified domain name (FQDN) of the remote domain with which you are deleting the conditional forwarder.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.conditional_forwarder.delete(
                ctx, directory_id=value, remote_domain_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.conditional_forwarder.delete directory_id=value, remote_domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="delete_conditional_forwarder",
        op_kwargs={"DirectoryId": directory_id, "RemoteDomainName": remote_domain_name},
    )


async def describe_all(
    hub, ctx, directory_id: str, remote_domain_names: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Obtains information about the conditional forwarders for this account. If no input parameters are provided for RemoteDomainNames, this request describes all conditional forwarders for the specified directory ID.

    Args:
        directory_id(str): The directory ID for which to get the list of associated conditional forwarders.
        remote_domain_names(List, optional): The fully qualified domain names (FQDN) of the remote domains for which to get the list of associated conditional forwarders. If this member is null, all conditional forwarders are returned. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.conditional_forwarder.describe_all(ctx, directory_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.conditional_forwarder.describe_all directory_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="describe_conditional_forwarders",
        op_kwargs={
            "DirectoryId": directory_id,
            "RemoteDomainNames": remote_domain_names,
        },
    )


async def update(
    hub, ctx, directory_id: str, remote_domain_name: str, dns_ip_addrs: List
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a conditional forwarder that has been set up for your AWS directory.

    Args:
        directory_id(str): The directory ID of the AWS directory for which to update the conditional forwarder.
        remote_domain_name(str): The fully qualified domain name (FQDN) of the remote domain with which you will set up a trust relationship.
        dns_ip_addrs(List): The updated IP addresses of the remote DNS server associated with the conditional forwarder.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.conditional_forwarder.update(
                ctx, directory_id=value, remote_domain_name=value, dns_ip_addrs=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.conditional_forwarder.update directory_id=value, remote_domain_name=value, dns_ip_addrs=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="update_conditional_forwarder",
        op_kwargs={
            "DirectoryId": directory_id,
            "RemoteDomainName": remote_domain_name,
            "DnsIpAddrs": dns_ip_addrs,
        },
    )
