"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    directory_id: str,
    computer_name: str,
    password: str,
    organizational_unit_distinguished_name: str = None,
    computer_attributes: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Active Directory computer object in the specified directory.

    Args:
        directory_id(str): The identifier of the directory in which to create the computer account.
        computer_name(str): The name of the computer account.
        password(str): A one-time password that is used to join the computer to the directory. You should generate a random, strong password to use for this parameter.
        organizational_unit_distinguished_name(str, optional): The fully-qualified distinguished name of the organizational unit to place the computer account in. Defaults to None.
        computer_attributes(List, optional): An array of Attribute objects that contain any LDAP attributes to apply to the computer account. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.computer.create(
                ctx, directory_id=value, computer_name=value, password=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.computer.create directory_id=value, computer_name=value, password=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="create_computer",
        op_kwargs={
            "DirectoryId": directory_id,
            "ComputerName": computer_name,
            "Password": password,
            "OrganizationalUnitDistinguishedName": organizational_unit_distinguished_name,
            "ComputerAttributes": computer_attributes,
        },
    )
