"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disable(hub, ctx, directory_id: str, type_: str) -> Dict:
    r"""
    **Autogenerated function**

    Disables alternative client authentication methods for the specified directory.

    Args:
        directory_id(str): The identifier of the directory .
        type_(str): The type of client authentication to disable. Currently, only the parameter, SmartCard is supported.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.client_authentication.disable(
                ctx, directory_id=value, type_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.client_authentication.disable directory_id=value, type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="disable_client_authentication",
        op_kwargs={"DirectoryId": directory_id, "Type": type_},
    )


async def enable(hub, ctx, directory_id: str, type_: str) -> Dict:
    r"""
    **Autogenerated function**

    Enables alternative client authentication methods for the specified directory.

    Args:
        directory_id(str): The identifier of the specified directory. .
        type_(str): The type of client authentication to enable. Currently only the value SmartCard is supported. Smart card authentication in AD Connector requires that you enable Kerberos Constrained Delegation for the Service User to the LDAP service in the on-premises AD. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.client_authentication.enable(
                ctx, directory_id=value, type_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.client_authentication.enable directory_id=value, type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="enable_client_authentication",
        op_kwargs={"DirectoryId": directory_id, "Type": type_},
    )
