"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def deregister(hub, ctx, directory_id: str, certificate_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes from the system the certificate that was registered for secure LDAP or client certificate authentication.

    Args:
        directory_id(str): The identifier of the directory.
        certificate_id(str): The identifier of the certificate.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.certificate.deregister(
                ctx, directory_id=value, certificate_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.certificate.deregister directory_id=value, certificate_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="deregister_certificate",
        op_kwargs={"DirectoryId": directory_id, "CertificateId": certificate_id},
    )


async def describe(hub, ctx, directory_id: str, certificate_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Displays information about the certificate registered for secure LDAP or client certificate authentication.

    Args:
        directory_id(str): The identifier of the directory.
        certificate_id(str): The identifier of the certificate.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.certificate.describe(
                ctx, directory_id=value, certificate_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.certificate.describe directory_id=value, certificate_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="describe_certificate",
        op_kwargs={"DirectoryId": directory_id, "CertificateId": certificate_id},
    )


async def list_all(
    hub, ctx, directory_id: str, next_token: str = None, limit: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    For the specified directory, lists all the certificates registered for a secure LDAP or client certificate authentication.

    Args:
        directory_id(str): The identifier of the directory.
        next_token(str, optional): A token for requesting another page of certificates if the NextToken response element indicates that more certificates are available. Use the value of the returned NextToken element in your request until the token comes back as null. Pass null if this is the first call. Defaults to None.
        limit(int, optional): The number of items that should show up on one page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.certificate.list_all(ctx, directory_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.certificate.list_all directory_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="list_certificates",
        op_kwargs={
            "DirectoryId": directory_id,
            "NextToken": next_token,
            "Limit": limit,
        },
    )


async def register(
    hub,
    ctx,
    directory_id: str,
    certificate_data: str,
    type_: str = None,
    client_cert_auth_settings: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Registers a certificate for a secure LDAP or client certificate authentication.

    Args:
        directory_id(str): The identifier of the directory.
        certificate_data(str): The certificate PEM string that needs to be registered.
        type_(str, optional): The function that the registered certificate performs. Valid values include ClientLDAPS or ClientCertAuth. The default value is ClientLDAPS. Defaults to None.
        client_cert_auth_settings(Dict, optional): A ClientCertAuthSettings object that contains client certificate authentication settings. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.certificate.register(
                ctx, directory_id=value, certificate_data=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.certificate.register directory_id=value, certificate_data=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="register_certificate",
        op_kwargs={
            "DirectoryId": directory_id,
            "CertificateData": certificate_data,
            "Type": type_,
            "ClientCertAuthSettings": client_cert_auth_settings,
        },
    )
