"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, directory_id: str, alias: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates an alias for a directory and assigns the alias to the directory. The alias is used to construct the access URL for the directory, such as http://<alias>.awsapps.com.  After an alias has been created, it cannot be deleted or reused, so this operation should only be used when absolutely necessary.

    Args:
        directory_id(str): The identifier of the directory for which to create the alias.
        alias(str): The requested alias. The alias must be unique amongst all aliases in AWS. This operation throws an EntityAlreadyExistsException error if the alias already exists.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ds.alias.create(ctx, directory_id=value, alias=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ds.alias.create directory_id=value, alias=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ds",
        operation="create_alias",
        op_kwargs={"DirectoryId": directory_id, "Alias": alias},
    )
