"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import List


async def add(hub, ctx, resource_name: str, tags: List) -> None:
    r"""
    **Autogenerated function**

    Adds metadata tags to an Amazon DocumentDB resource. You can use these tags with cost allocation reporting to track costs that are associated with Amazon DocumentDB resources or in a Condition statement in an Identity and Access Management (IAM) policy for Amazon DocumentDB.

    Args:
        resource_name(str): The Amazon DocumentDB resource that the tags are added to. This value is an Amazon Resource Name .
        tags(List): The tags to be assigned to the Amazon DocumentDB resource.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.docdb.tags.to_resource.add(ctx, resource_name=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.docdb.tags.to_resource.add resource_name=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="docdb",
        operation="add_tags_to_resource",
        op_kwargs={"ResourceName": resource_name, "Tags": tags},
    )
