"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def apply(
    hub, ctx, resource_identifier: str, apply_action: str, opt_in_type: str
) -> Dict:
    r"""
    **Autogenerated function**

    Applies a pending maintenance action to a resource (for example, to an Amazon DocumentDB instance).

    Args:
        resource_identifier(str): The Amazon Resource Name (ARN) of the resource that the pending maintenance action applies to.
        apply_action(str): The pending maintenance action to apply to this resource. Valid values: system-update, db-upgrade .
        opt_in_type(str): A value that specifies the type of opt-in request or undoes an opt-in request. An opt-in request of type immediate can't be undone. Valid values:    immediate - Apply the maintenance action immediately.    next-maintenance - Apply the maintenance action during the next maintenance window for the resource.     undo-opt-in - Cancel any existing next-maintenance opt-in requests.  .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.docdb.pending_maintenance_action.apply(
                ctx, resource_identifier=value, apply_action=value, opt_in_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.docdb.pending_maintenance_action.apply resource_identifier=value, apply_action=value, opt_in_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="docdb",
        operation="apply_pending_maintenance_action",
        op_kwargs={
            "ResourceIdentifier": resource_identifier,
            "ApplyAction": apply_action,
            "OptInType": opt_in_type,
        },
    )


async def describe_all(
    hub,
    ctx,
    resource_identifier: str = None,
    filters: List = None,
    marker: str = None,
    max_records: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of resources (for example, instances) that have at least one pending maintenance action.

    Args:
        resource_identifier(str, optional): The ARN of a resource to return pending maintenance actions for. Defaults to None.
        filters(List, optional): A filter that specifies one or more resources to return pending maintenance actions for. Supported filters:    db-cluster-id - Accepts cluster identifiers and cluster Amazon Resource Names (ARNs). The results list includes only pending maintenance actions for the clusters identified by these ARNs.    db-instance-id - Accepts instance identifiers and instance ARNs. The results list includes only pending maintenance actions for the DB instances identified by these ARNs.  . Defaults to None.
        marker(str, optional): An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. Defaults to None.
        max_records(int, optional):  The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token (marker) is included in the response so that the remaining results can be retrieved. Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.docdb.pending_maintenance_action.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.docdb.pending_maintenance_action.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="docdb",
        operation="describe_pending_maintenance_actions",
        op_kwargs={
            "ResourceIdentifier": resource_identifier,
            "Filters": filters,
            "Marker": marker,
            "MaxRecords": max_records,
        },
    )
