"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    engine: str,
    engine_version: str = None,
    db_instance_class: str = None,
    license_model: str = None,
    vpc: bool = None,
    filters: List = None,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of orderable instance options for the specified engine.

    Args:
        engine(str): The name of the engine to retrieve instance options for.
        engine_version(str, optional): The engine version filter value. Specify this parameter to show only the available offerings that match the specified engine version. Defaults to None.
        db_instance_class(str, optional): The instance class filter value. Specify this parameter to show only the available offerings that match the specified instance class. Defaults to None.
        license_model(str, optional): The license model filter value. Specify this parameter to show only the available offerings that match the specified license model. Defaults to None.
        vpc(bool, optional): The virtual private cloud (VPC) filter value. Specify this parameter to show only the available VPC or non-VPC offerings. Defaults to None.
        filters(List, optional): This parameter is not currently supported. Defaults to None.
        max_records(int, optional):  The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token (marker) is included in the response so that the remaining results can be retrieved. Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.
        marker(str, optional): An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.docdb.orderable_db_instance_option.describe_all(
                ctx, engine=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.docdb.orderable_db_instance_option.describe_all engine=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="docdb",
        operation="describe_orderable_db_instance_options",
        op_kwargs={
            "Engine": engine,
            "EngineVersion": engine_version,
            "DBInstanceClass": db_instance_class,
            "LicenseModel": license_model,
            "Vpc": vpc,
            "Filters": filters,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )
