"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    global_cluster_identifier: str,
    source_db_cluster_identifier: str = None,
    engine: str = None,
    engine_version: str = None,
    deletion_protection: bool = None,
    database_name: str = None,
    storage_encrypted: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Amazon DocumentDB global cluster that can span multiple multiple Regions. The global cluster contains one primary cluster with read-write capability, and up-to give read-only secondary clusters. Global clusters uses storage-based fast replication across regions with latencies less than one second, using dedicated infrastructure with no impact to your workload’s performance.  You can create a global cluster that is initially empty, and then add a primary and a secondary to it. Or you can specify an existing cluster during the create operation, and this cluster becomes the primary of the global cluster.   This action only applies to Amazon DocumentDB clusters.

    Args:
        global_cluster_identifier(str): The cluster identifier of the new global cluster.
        source_db_cluster_identifier(str, optional): The Amazon Resource Name (ARN) to use as the primary cluster of the global cluster. This parameter is optional. Defaults to None.
        engine(str, optional): The name of the database engine to be used for this cluster. Defaults to None.
        engine_version(str, optional): The engine version of the global cluster. Defaults to None.
        deletion_protection(bool, optional): The deletion protection setting for the new global cluster. The global cluster can't be deleted when deletion protection is enabled. . Defaults to None.
        database_name(str, optional): The name for your database of up to 64 alpha-numeric characters. If you do not provide a name, Amazon DocumentDB will not create a database in the global cluster you are creating. Defaults to None.
        storage_encrypted(bool, optional): The storage encryption setting for the new global cluster. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.docdb.global_cluster.create(
                ctx, global_cluster_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.docdb.global_cluster.create global_cluster_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="docdb",
        operation="create_global_cluster",
        op_kwargs={
            "GlobalClusterIdentifier": global_cluster_identifier,
            "SourceDBClusterIdentifier": source_db_cluster_identifier,
            "Engine": engine,
            "EngineVersion": engine_version,
            "DeletionProtection": deletion_protection,
            "DatabaseName": database_name,
            "StorageEncrypted": storage_encrypted,
        },
    )


async def delete(hub, ctx, global_cluster_identifier: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a global cluster. The primary and secondary clusters must already be detached or deleted before attempting to delete a global cluster.  This action only applies to Amazon DocumentDB clusters.

    Args:
        global_cluster_identifier(str): The cluster identifier of the global cluster being deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.docdb.global_cluster.delete(
                ctx, global_cluster_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.docdb.global_cluster.delete global_cluster_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="docdb",
        operation="delete_global_cluster",
        op_kwargs={"GlobalClusterIdentifier": global_cluster_identifier},
    )


async def describe_all(
    hub,
    ctx,
    global_cluster_identifier: str = None,
    filters: List = None,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about Amazon DocumentDB global clusters. This API supports pagination.  This action only applies to Amazon DocumentDB clusters.

    Args:
        global_cluster_identifier(str, optional): The user-supplied cluster identifier. If this parameter is specified, information from only the specific cluster is returned. This parameter isn't case-sensitive. Defaults to None.
        filters(List, optional): A filter that specifies one or more global DB clusters to describe. Supported filters: db-cluster-id accepts cluster identifiers and cluster Amazon Resource Names (ARNs). The results list will only include information about the clusters identified by these ARNs. Defaults to None.
        max_records(int, optional): The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so that you can retrieve the remaining results. . Defaults to None.
        marker(str, optional): An optional pagination token provided by a previous DescribeGlobalClusters request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.docdb.global_cluster.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.docdb.global_cluster.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="docdb",
        operation="describe_global_clusters",
        op_kwargs={
            "GlobalClusterIdentifier": global_cluster_identifier,
            "Filters": filters,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )


async def modify(
    hub,
    ctx,
    global_cluster_identifier: str,
    new_global_cluster_identifier: str = None,
    deletion_protection: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modify a setting for an Amazon DocumentDB global cluster. You can change one or more configuration parameters (for example: deletion protection), or the global cluster identifier by specifying these parameters and the new values in the request.  This action only applies to Amazon DocumentDB clusters.

    Args:
        global_cluster_identifier(str): The identifier for the global cluster being modified. This parameter isn't case-sensitive. Constraints:   Must match the identifier of an existing global cluster.  .
        new_global_cluster_identifier(str, optional): The new identifier for a global cluster when you modify a global cluster. This value is stored as a lowercase string.   Must contain from 1 to 63 letters, numbers, or hyphens The first character must be a letter Can't end with a hyphen or contain two consecutive hyphens   Example: my-cluster2 . Defaults to None.
        deletion_protection(bool, optional): Indicates if the global cluster has deletion protection enabled. The global cluster can't be deleted when deletion protection is enabled. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.docdb.global_cluster.modify(
                ctx, global_cluster_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.docdb.global_cluster.modify global_cluster_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="docdb",
        operation="modify_global_cluster",
        op_kwargs={
            "GlobalClusterIdentifier": global_cluster_identifier,
            "NewGlobalClusterIdentifier": new_global_cluster_identifier,
            "DeletionProtection": deletion_protection,
        },
    )
