"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def remove(
    hub, ctx, global_cluster_identifier: str, db_cluster_identifier: str
) -> Dict:
    r"""
    **Autogenerated function**

    Detaches an Amazon DocumentDB secondary cluster from a global cluster. The cluster becomes a standalone cluster with read-write capability instead of being read-only and receiving data from a primary in a different region.   This action only applies to Amazon DocumentDB clusters.

    Args:
        global_cluster_identifier(str): The cluster identifier to detach from the Amazon DocumentDB global cluster. .
        db_cluster_identifier(str): The Amazon Resource Name (ARN) identifying the cluster that was detached from the Amazon DocumentDB global cluster. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.docdb.from_global_cluster.remove(
                ctx, global_cluster_identifier=value, db_cluster_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.docdb.from_global_cluster.remove global_cluster_identifier=value, db_cluster_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="docdb",
        operation="remove_from_global_cluster",
        op_kwargs={
            "GlobalClusterIdentifier": global_cluster_identifier,
            "DbClusterIdentifier": db_cluster_identifier,
        },
    )
