"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    source_identifier: str = None,
    source_type: str = None,
    start_time: str = None,
    end_time: str = None,
    duration: int = None,
    event_categories: List = None,
    filters: List = None,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns events related to instances, security groups, snapshots, and DB parameter groups for the past 14 days. You can obtain events specific to a particular DB instance, security group, snapshot, or parameter group by providing the name as a parameter. By default, the events of the past hour are returned.

    Args:
        source_identifier(str, optional): The identifier of the event source for which events are returned. If not specified, then all sources are included in the response. Constraints:   If SourceIdentifier is provided, SourceType must also be provided.   If the source type is DBInstance, a DBInstanceIdentifier must be provided.   If the source type is DBSecurityGroup, a DBSecurityGroupName must be provided.   If the source type is DBParameterGroup, a DBParameterGroupName must be provided.   If the source type is DBSnapshot, a DBSnapshotIdentifier must be provided.   Cannot end with a hyphen or contain two consecutive hyphens.  . Defaults to None.
        source_type(str, optional): The event source to retrieve events for. If no value is specified, all events are returned. Defaults to None.
        start_time(str, optional):  The beginning of the time interval to retrieve events for, specified in ISO 8601 format.  Example: 2009-07-08T18:00Z. Defaults to None.
        end_time(str, optional):  The end of the time interval for which to retrieve events, specified in ISO 8601 format.  Example: 2009-07-08T18:00Z. Defaults to None.
        duration(int, optional): The number of minutes to retrieve events for. Default: 60. Defaults to None.
        event_categories(List, optional): A list of event categories that trigger notifications for an event notification subscription. Defaults to None.
        filters(List, optional): This parameter is not currently supported. Defaults to None.
        max_records(int, optional):  The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token (marker) is included in the response so that the remaining results can be retrieved. Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.
        marker(str, optional): An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.docdb.event.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.docdb.event.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="docdb",
        operation="describe_events",
        op_kwargs={
            "SourceIdentifier": source_identifier,
            "SourceType": source_type,
            "StartTime": start_time,
            "EndTime": end_time,
            "Duration": duration,
            "EventCategories": event_categories,
            "Filters": filters,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )
