"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    db_instance_identifier: str,
    db_instance_class: str,
    engine: str,
    db_cluster_identifier: str,
    availability_zone: str = None,
    preferred_maintenance_window: str = None,
    auto_minor_version_upgrade: bool = None,
    tags: List = None,
    promotion_tier: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new instance.

    Args:
        db_instance_identifier(str): The instance identifier. This parameter is stored as a lowercase string. Constraints:   Must contain from 1 to 63 letters, numbers, or hyphens.   The first character must be a letter.   Cannot end with a hyphen or contain two consecutive hyphens.   Example: mydbinstance .
        db_instance_class(str): The compute and memory capacity of the instance; for example, db.r5.large. .
        engine(str): The name of the database engine to be used for this instance. Valid value: docdb .
        availability_zone(str, optional): The Amazon EC2 Availability Zone that the instance is created in.  Default: A random, system-chosen Availability Zone in the endpoint's Region. Example: us-east-1d . Defaults to None.
        preferred_maintenance_window(str, optional): The time range each week during which system maintenance can occur, in Universal Coordinated Time (UTC).  Format: ddd:hh24:mi-ddd:hh24:mi  The default is a 30-minute window selected at random from an 8-hour block of time for each Region, occurring on a random day of the week.  Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun Constraints: Minimum 30-minute window. Defaults to None.
        auto_minor_version_upgrade(bool, optional): This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set. Default: false . Defaults to None.
        tags(List, optional): The tags to be assigned to the instance. You can assign up to 10 tags to an instance. Defaults to None.
        db_cluster_identifier(str): The identifier of the cluster that the instance will belong to.
        promotion_tier(int, optional): A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary instance after a failure of the existing primary instance. Default: 1 Valid values: 0-15. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.docdb.db.instance.create(
                ctx,
                db_instance_identifier=value,
                db_instance_class=value,
                engine=value,
                db_cluster_identifier=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.docdb.db.instance.create db_instance_identifier=value, db_instance_class=value, engine=value, db_cluster_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="docdb",
        operation="create_db_instance",
        op_kwargs={
            "DBInstanceIdentifier": db_instance_identifier,
            "DBInstanceClass": db_instance_class,
            "Engine": engine,
            "AvailabilityZone": availability_zone,
            "PreferredMaintenanceWindow": preferred_maintenance_window,
            "AutoMinorVersionUpgrade": auto_minor_version_upgrade,
            "Tags": tags,
            "DBClusterIdentifier": db_cluster_identifier,
            "PromotionTier": promotion_tier,
        },
    )


async def delete(hub, ctx, db_instance_identifier: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a previously provisioned instance.

    Args:
        db_instance_identifier(str): The instance identifier for the instance to be deleted. This parameter isn't case sensitive. Constraints:   Must match the name of an existing instance.  .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.docdb.db.instance.delete(ctx, db_instance_identifier=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.docdb.db.instance.delete db_instance_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="docdb",
        operation="delete_db_instance",
        op_kwargs={"DBInstanceIdentifier": db_instance_identifier},
    )


async def describe_all(
    hub,
    ctx,
    db_instance_identifier: str = None,
    filters: List = None,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about provisioned Amazon DocumentDB instances. This API supports pagination.

    Args:
        db_instance_identifier(str, optional): The user-provided instance identifier. If this parameter is specified, information from only the specific instance is returned. This parameter isn't case sensitive. Constraints:   If provided, must match the identifier of an existing DBInstance.  . Defaults to None.
        filters(List, optional): A filter that specifies one or more instances to describe. Supported filters:    db-cluster-id - Accepts cluster identifiers and cluster Amazon Resource Names (ARNs). The results list includes only the information about the instances that are associated with the clusters that are identified by these ARNs.    db-instance-id - Accepts instance identifiers and instance ARNs. The results list includes only the information about the instances that are identified by these ARNs.  . Defaults to None.
        max_records(int, optional):  The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token (marker) is included in the response so that the remaining results can be retrieved. Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.
        marker(str, optional): An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.docdb.db.instance.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.docdb.db.instance.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="docdb",
        operation="describe_db_instances",
        op_kwargs={
            "DBInstanceIdentifier": db_instance_identifier,
            "Filters": filters,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )


async def modify(
    hub,
    ctx,
    db_instance_identifier: str,
    db_instance_class: str = None,
    apply_immediately: bool = None,
    preferred_maintenance_window: str = None,
    auto_minor_version_upgrade: bool = None,
    new_db_instance_identifier: str = None,
    ca_certificate_identifier: str = None,
    promotion_tier: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies settings for an instance. You can change one or more database configuration parameters by specifying these parameters and the new values in the request.

    Args:
        db_instance_identifier(str): The instance identifier. This value is stored as a lowercase string. Constraints:   Must match the identifier of an existing DBInstance.  .
        db_instance_class(str, optional): The new compute and memory capacity of the instance; for example, db.r5.large. Not all instance classes are available in all Regions.  If you modify the instance class, an outage occurs during the change. The change is applied during the next maintenance window, unless ApplyImmediately is specified as true for this request.  Default: Uses existing setting. Defaults to None.
        apply_immediately(bool, optional): Specifies whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the PreferredMaintenanceWindow setting for the instance.   If this parameter is set to false, changes to the instance are applied during the next maintenance window. Some parameter changes can cause an outage and are applied on the next reboot. Default: false . Defaults to None.
        preferred_maintenance_window(str, optional): The weekly time range (in UTC) during which system maintenance can occur, which might result in an outage. Changing this parameter doesn't result in an outage except in the following situation, and the change is asynchronously applied as soon as possible. If there are pending actions that cause a reboot, and the maintenance window is changed to include the current time, changing this parameter causes a reboot of the instance. If you are moving this window to the current time, there must be at least 30 minutes between the current time and end of the window to ensure that pending changes are applied. Default: Uses existing setting. Format: ddd:hh24:mi-ddd:hh24:mi  Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun Constraints: Must be at least 30 minutes. Defaults to None.
        auto_minor_version_upgrade(bool, optional): This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set. Defaults to None.
        new_db_instance_identifier(str, optional):  The new instance identifier for the instance when renaming an instance. When you change the instance identifier, an instance reboot occurs immediately if you set Apply Immediately to true. It occurs during the next maintenance window if you set Apply Immediately to false. This value is stored as a lowercase string.  Constraints:   Must contain from 1 to 63 letters, numbers, or hyphens.   The first character must be a letter.   Cannot end with a hyphen or contain two consecutive hyphens.   Example: mydbinstance . Defaults to None.
        ca_certificate_identifier(str, optional): Indicates the certificate that needs to be associated with the instance. Defaults to None.
        promotion_tier(int, optional): A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary instance after a failure of the existing primary instance. Default: 1 Valid values: 0-15. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.docdb.db.instance.modify(ctx, db_instance_identifier=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.docdb.db.instance.modify db_instance_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="docdb",
        operation="modify_db_instance",
        op_kwargs={
            "DBInstanceIdentifier": db_instance_identifier,
            "DBInstanceClass": db_instance_class,
            "ApplyImmediately": apply_immediately,
            "PreferredMaintenanceWindow": preferred_maintenance_window,
            "AutoMinorVersionUpgrade": auto_minor_version_upgrade,
            "NewDBInstanceIdentifier": new_db_instance_identifier,
            "CACertificateIdentifier": ca_certificate_identifier,
            "PromotionTier": promotion_tier,
        },
    )


async def reboot(
    hub, ctx, db_instance_identifier: str, force_failover: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    You might need to reboot your instance, usually for maintenance reasons. For example, if you make certain changes, or if you change the cluster parameter group that is associated with the instance, you must reboot the instance for the changes to take effect.  Rebooting an instance restarts the database engine service. Rebooting an instance results in a momentary outage, during which the instance status is set to rebooting.

    Args:
        db_instance_identifier(str): The instance identifier. This parameter is stored as a lowercase string. Constraints:   Must match the identifier of an existing DBInstance.  .
        force_failover(bool, optional):  When true, the reboot is conducted through a Multi-AZ failover.  Constraint: You can't specify true if the instance is not configured for Multi-AZ. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.docdb.db.instance.reboot(ctx, db_instance_identifier=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.docdb.db.instance.reboot db_instance_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="docdb",
        operation="reboot_db_instance",
        op_kwargs={
            "DBInstanceIdentifier": db_instance_identifier,
            "ForceFailover": force_failover,
        },
    )
