"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    engine: str = None,
    engine_version: str = None,
    db_parameter_group_family: str = None,
    filters: List = None,
    max_records: int = None,
    marker: str = None,
    default_only: bool = None,
    list_supported_character_sets: bool = None,
    list_supported_timezones: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of the available engines.

    Args:
        engine(str, optional): The database engine to return. Defaults to None.
        engine_version(str, optional): The database engine version to return. Example: 3.6.0 . Defaults to None.
        db_parameter_group_family(str, optional): The name of a specific parameter group family to return details for. Constraints:   If provided, must match an existing DBParameterGroupFamily.  . Defaults to None.
        filters(List, optional): This parameter is not currently supported. Defaults to None.
        max_records(int, optional):  The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token (marker) is included in the response so that the remaining results can be retrieved. Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.
        marker(str, optional): An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. Defaults to None.
        default_only(bool, optional): Indicates that only the default version of the specified engine or engine and major version combination is returned. Defaults to None.
        list_supported_character_sets(bool, optional): If this parameter is specified and the requested engine supports the CharacterSetName parameter for CreateDBInstance, the response includes a list of supported character sets for each engine version. . Defaults to None.
        list_supported_timezones(bool, optional): If this parameter is specified and the requested engine supports the TimeZone parameter for CreateDBInstance, the response includes a list of supported time zones for each engine version. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.docdb.db.engine_version.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.docdb.db.engine_version.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="docdb",
        operation="describe_db_engine_versions",
        op_kwargs={
            "Engine": engine,
            "EngineVersion": engine_version,
            "DBParameterGroupFamily": db_parameter_group_family,
            "Filters": filters,
            "MaxRecords": max_records,
            "Marker": marker,
            "DefaultOnly": default_only,
            "ListSupportedCharacterSets": list_supported_character_sets,
            "ListSupportedTimezones": list_supported_timezones,
        },
    )
