"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(hub, ctx, db_cluster_snapshot_identifier: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of cluster snapshot attribute names and values for a manual DB cluster snapshot. When you share snapshots with other accounts, DescribeDBClusterSnapshotAttributes returns the restore attribute and a list of IDs for the accounts that are authorized to copy or restore the manual cluster snapshot. If all is included in the list of values for the restore attribute, then the manual cluster snapshot is public and can be copied or restored by all accounts.

    Args:
        db_cluster_snapshot_identifier(str): The identifier for the cluster snapshot to describe the attributes for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.docdb.db.cluster.snapshot.attribute.describe_all(
                ctx, db_cluster_snapshot_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.docdb.db.cluster.snapshot.attribute.describe_all db_cluster_snapshot_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="docdb",
        operation="describe_db_cluster_snapshot_attributes",
        op_kwargs={"DBClusterSnapshotIdentifier": db_cluster_snapshot_identifier},
    )


async def modify(
    hub,
    ctx,
    db_cluster_snapshot_identifier: str,
    attribute_name: str,
    values_to_add: List = None,
    values_to_remove: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds an attribute and values to, or removes an attribute and values from, a manual cluster snapshot. To share a manual cluster snapshot with other accounts, specify restore as the AttributeName, and use the ValuesToAdd parameter to add a list of IDs of the accounts that are authorized to restore the manual cluster snapshot. Use the value all to make the manual cluster snapshot public, which means that it can be copied or restored by all accounts. Do not add the all value for any manual cluster snapshots that contain private information that you don't want available to all accounts. If a manual cluster snapshot is encrypted, it can be shared, but only by specifying a list of authorized account IDs for the ValuesToAdd parameter. You can't use all as a value for that parameter in this case.

    Args:
        db_cluster_snapshot_identifier(str): The identifier for the cluster snapshot to modify the attributes for.
        attribute_name(str): The name of the cluster snapshot attribute to modify. To manage authorization for other accounts to copy or restore a manual cluster snapshot, set this value to restore.
        values_to_add(List, optional): A list of cluster snapshot attributes to add to the attribute specified by AttributeName. To authorize other accounts to copy or restore a manual cluster snapshot, set this list to include one or more account IDs. To make the manual cluster snapshot restorable by any account, set it to all. Do not add the all value for any manual cluster snapshots that contain private information that you don't want to be available to all accounts. Defaults to None.
        values_to_remove(List, optional): A list of cluster snapshot attributes to remove from the attribute specified by AttributeName. To remove authorization for other accounts to copy or restore a manual cluster snapshot, set this list to include one or more account identifiers. To remove authorization for any account to copy or restore the cluster snapshot, set it to all . If you specify all, an account whose account ID is explicitly added to the restore attribute can still copy or restore a manual cluster snapshot. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.docdb.db.cluster.snapshot.attribute.modify(
                ctx, db_cluster_snapshot_identifier=value, attribute_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.docdb.db.cluster.snapshot.attribute.modify db_cluster_snapshot_identifier=value, attribute_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="docdb",
        operation="modify_db_cluster_snapshot_attribute",
        op_kwargs={
            "DBClusterSnapshotIdentifier": db_cluster_snapshot_identifier,
            "AttributeName": attribute_name,
            "ValuesToAdd": values_to_add,
            "ValuesToRemove": values_to_remove,
        },
    )
