"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def copy(
    hub,
    ctx,
    source_db_cluster_parameter_group_identifier: str,
    target_db_cluster_parameter_group_identifier: str,
    target_db_cluster_parameter_group_description: str,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Copies the specified cluster parameter group.

    Args:
        source_db_cluster_parameter_group_identifier(str): The identifier or Amazon Resource Name (ARN) for the source cluster parameter group. Constraints:   Must specify a valid cluster parameter group.   If the source cluster parameter group is in the same Region as the copy, specify a valid parameter group identifier; for example, my-db-cluster-param-group, or a valid ARN.   If the source parameter group is in a different Region than the copy, specify a valid cluster parameter group ARN; for example, arn:aws:rds:us-east-1:123456789012:sample-cluster:sample-parameter-group.  .
        target_db_cluster_parameter_group_identifier(str): The identifier for the copied cluster parameter group. Constraints:   Cannot be null, empty, or blank.   Must contain from 1 to 255 letters, numbers, or hyphens.    The first character must be a letter.   Cannot end with a hyphen or contain two consecutive hyphens.    Example: my-cluster-param-group1 .
        target_db_cluster_parameter_group_description(str): A description for the copied cluster parameter group.
        tags(List, optional): The tags that are to be assigned to the parameter group. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.docdb.db.cluster.parameter.group.copy(
                ctx,
                source_db_cluster_parameter_group_identifier=value,
                target_db_cluster_parameter_group_identifier=value,
                target_db_cluster_parameter_group_description=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.docdb.db.cluster.parameter.group.copy source_db_cluster_parameter_group_identifier=value, target_db_cluster_parameter_group_identifier=value, target_db_cluster_parameter_group_description=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="docdb",
        operation="copy_db_cluster_parameter_group",
        op_kwargs={
            "SourceDBClusterParameterGroupIdentifier": source_db_cluster_parameter_group_identifier,
            "TargetDBClusterParameterGroupIdentifier": target_db_cluster_parameter_group_identifier,
            "TargetDBClusterParameterGroupDescription": target_db_cluster_parameter_group_description,
            "Tags": tags,
        },
    )


async def create(
    hub,
    ctx,
    db_cluster_parameter_group_name: str,
    db_parameter_group_family: str,
    description: str,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new cluster parameter group. Parameters in a cluster parameter group apply to all of the instances in a cluster. A cluster parameter group is initially created with the default parameters for the database engine used by instances in the cluster. In Amazon DocumentDB, you cannot make modifications directly to the default.docdb3.6 cluster parameter group. If your Amazon DocumentDB cluster is using the default cluster parameter group and you want to modify a value in it, you must first  create a new parameter group or  copy an existing parameter group, modify it, and then apply the modified parameter group to your cluster. For the new cluster parameter group and associated settings to take effect, you must then reboot the instances in the cluster without failover. For more information, see  Modifying Amazon DocumentDB Cluster Parameter Groups.

    Args:
        db_cluster_parameter_group_name(str): The name of the cluster parameter group. Constraints:   Must not match the name of an existing DBClusterParameterGroup.    This value is stored as a lowercase string. .
        db_parameter_group_family(str): The cluster parameter group family name.
        description(str): The description for the cluster parameter group.
        tags(List, optional): The tags to be assigned to the cluster parameter group. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.docdb.db.cluster.parameter.group.create(
                ctx,
                db_cluster_parameter_group_name=value,
                db_parameter_group_family=value,
                description=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.docdb.db.cluster.parameter.group.create db_cluster_parameter_group_name=value, db_parameter_group_family=value, description=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="docdb",
        operation="create_db_cluster_parameter_group",
        op_kwargs={
            "DBClusterParameterGroupName": db_cluster_parameter_group_name,
            "DBParameterGroupFamily": db_parameter_group_family,
            "Description": description,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, db_cluster_parameter_group_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a specified cluster parameter group. The cluster parameter group to be deleted can't be associated with any clusters.

    Args:
        db_cluster_parameter_group_name(str): The name of the cluster parameter group. Constraints:   Must be the name of an existing cluster parameter group.   You can't delete a default cluster parameter group.   Cannot be associated with any clusters.  .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.docdb.db.cluster.parameter.group.delete(
                ctx, db_cluster_parameter_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.docdb.db.cluster.parameter.group.delete db_cluster_parameter_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="docdb",
        operation="delete_db_cluster_parameter_group",
        op_kwargs={"DBClusterParameterGroupName": db_cluster_parameter_group_name},
    )


async def describe_all(
    hub,
    ctx,
    db_cluster_parameter_group_name: str = None,
    filters: List = None,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of DBClusterParameterGroup descriptions. If a DBClusterParameterGroupName parameter is specified, the list contains only the description of the specified cluster parameter group.

    Args:
        db_cluster_parameter_group_name(str, optional): The name of a specific cluster parameter group to return details for. Constraints:   If provided, must match the name of an existing DBClusterParameterGroup.  . Defaults to None.
        filters(List, optional): This parameter is not currently supported. Defaults to None.
        max_records(int, optional):  The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token (marker) is included in the response so that the remaining results can be retrieved. Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.
        marker(str, optional): An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.docdb.db.cluster.parameter.group.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.docdb.db.cluster.parameter.group.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="docdb",
        operation="describe_db_cluster_parameter_groups",
        op_kwargs={
            "DBClusterParameterGroupName": db_cluster_parameter_group_name,
            "Filters": filters,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )


async def modify(
    hub, ctx, db_cluster_parameter_group_name: str, parameters: List
) -> Dict:
    r"""
    **Autogenerated function**

     Modifies the parameters of a cluster parameter group. To modify more than one parameter, submit a list of the following: ParameterName, ParameterValue, and ApplyMethod. A maximum of 20 parameters can be modified in a single request.   Changes to dynamic parameters are applied immediately. Changes to static parameters require a reboot or maintenance window before the change can take effect.   After you create a cluster parameter group, you should wait at least 5 minutes before creating your first cluster that uses that cluster parameter group as the default parameter group. This allows Amazon DocumentDB to fully complete the create action before the parameter group is used as the default for a new cluster. This step is especially important for parameters that are critical when creating the default database for a cluster, such as the character set for the default database defined by the character_set_database parameter.

    Args:
        db_cluster_parameter_group_name(str): The name of the cluster parameter group to modify.
        parameters(List): A list of parameters in the cluster parameter group to modify.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.docdb.db.cluster.parameter.group.modify(
                ctx, db_cluster_parameter_group_name=value, parameters=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.docdb.db.cluster.parameter.group.modify db_cluster_parameter_group_name=value, parameters=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="docdb",
        operation="modify_db_cluster_parameter_group",
        op_kwargs={
            "DBClusterParameterGroupName": db_cluster_parameter_group_name,
            "Parameters": parameters,
        },
    )


async def reset(
    hub,
    ctx,
    db_cluster_parameter_group_name: str,
    reset_all_parameters: bool = None,
    parameters: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Modifies the parameters of a cluster parameter group to the default value. To reset specific parameters, submit a list of the following: ParameterName and ApplyMethod. To reset the entire cluster parameter group, specify the DBClusterParameterGroupName and ResetAllParameters parameters.   When you reset the entire group, dynamic parameters are updated immediately and static parameters are set to pending-reboot to take effect on the next DB instance reboot.

    Args:
        db_cluster_parameter_group_name(str): The name of the cluster parameter group to reset.
        reset_all_parameters(bool, optional): A value that is set to true to reset all parameters in the cluster parameter group to their default values, and false otherwise. You can't use this parameter if there is a list of parameter names specified for the Parameters parameter. Defaults to None.
        parameters(List, optional): A list of parameter names in the cluster parameter group to reset to the default values. You can't use this parameter if the ResetAllParameters parameter is set to true. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.docdb.db.cluster.parameter.group.reset(
                ctx, db_cluster_parameter_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.docdb.db.cluster.parameter.group.reset db_cluster_parameter_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="docdb",
        operation="reset_db_cluster_parameter_group",
        op_kwargs={
            "DBClusterParameterGroupName": db_cluster_parameter_group_name,
            "ResetAllParameters": reset_all_parameters,
            "Parameters": parameters,
        },
    )
