"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    db_cluster_identifier: str,
    engine: str,
    availability_zones: List = None,
    backup_retention_period: int = None,
    db_cluster_parameter_group_name: str = None,
    vpc_security_group_ids: List = None,
    db_subnet_group_name: str = None,
    engine_version: str = None,
    port: int = None,
    master_username: str = None,
    master_user_password: str = None,
    preferred_backup_window: str = None,
    preferred_maintenance_window: str = None,
    tags: List = None,
    storage_encrypted: bool = None,
    kms_key_id: str = None,
    pre_signed_url: str = None,
    enable_cloudwatch_logs_exports: List = None,
    deletion_protection: bool = None,
    global_cluster_identifier: str = None,
    source_region: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new Amazon DocumentDB cluster.

    Args:
        availability_zones(List, optional): A list of Amazon EC2 Availability Zones that instances in the cluster can be created in. Defaults to None.
        backup_retention_period(int, optional): The number of days for which automated backups are retained. You must specify a minimum value of 1. Default: 1 Constraints:   Must be a value from 1 to 35.  . Defaults to None.
        db_cluster_identifier(str): The cluster identifier. This parameter is stored as a lowercase string. Constraints:   Must contain from 1 to 63 letters, numbers, or hyphens.    The first character must be a letter.   Cannot end with a hyphen or contain two consecutive hyphens.    Example: my-cluster .
        db_cluster_parameter_group_name(str, optional): The name of the cluster parameter group to associate with this cluster. Defaults to None.
        vpc_security_group_ids(List, optional): A list of EC2 VPC security groups to associate with this cluster. . Defaults to None.
        db_subnet_group_name(str, optional): A subnet group to associate with this cluster. Constraints: Must match the name of an existing DBSubnetGroup. Must not be default. Example: mySubnetgroup . Defaults to None.
        engine(str): The name of the database engine to be used for this cluster. Valid values: docdb .
        engine_version(str, optional): The version number of the database engine to use. The --engine-version will default to the latest major engine version. For production workloads, we recommend explicitly declaring this parameter with the intended major engine version. Defaults to None.
        port(int, optional): The port number on which the instances in the cluster accept connections. Defaults to None.
        master_username(str, optional): The name of the master user for the cluster. Constraints:   Must be from 1 to 63 letters or numbers.   The first character must be a letter.   Cannot be a reserved word for the chosen database engine.   . Defaults to None.
        master_user_password(str, optional): The password for the master database user. This password can contain any printable ASCII character except forward slash (/), double quote ("), or the "at" symbol (@). Constraints: Must contain from 8 to 100 characters. Defaults to None.
        preferred_backup_window(str, optional): The daily time range during which automated backups are created if automated backups are enabled using the BackupRetentionPeriod parameter.  The default is a 30-minute window selected at random from an 8-hour block of time for each Region.  Constraints:   Must be in the format hh24:mi-hh24:mi.   Must be in Universal Coordinated Time (UTC).   Must not conflict with the preferred maintenance window.    Must be at least 30 minutes.  . Defaults to None.
        preferred_maintenance_window(str, optional): The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC). Format: ddd:hh24:mi-ddd:hh24:mi  The default is a 30-minute window selected at random from an 8-hour block of time for each Region, occurring on a random day of the week. Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun Constraints: Minimum 30-minute window. Defaults to None.
        tags(List, optional): The tags to be assigned to the cluster. Defaults to None.
        storage_encrypted(bool, optional): Specifies whether the cluster is encrypted. Defaults to None.
        kms_key_id(str, optional): The KMS key identifier for an encrypted cluster. The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a cluster using the same account that owns the KMS encryption key that is used to encrypt the new cluster, you can use the KMS key alias instead of the ARN for the KMS encryption key. If an encryption key is not specified in KmsKeyId:    If the StorageEncrypted parameter is true, Amazon DocumentDB uses your default encryption key.    KMS creates the default encryption key for your account. Your account has a different default encryption key for each Regions. Defaults to None.
        pre_signed_url(str, optional): Not currently supported. . Defaults to None.
        enable_cloudwatch_logs_exports(List, optional): A list of log types that need to be enabled for exporting to Amazon CloudWatch Logs. You can enable audit logs or profiler logs. For more information, see  Auditing Amazon DocumentDB Events and  Profiling Amazon DocumentDB Operations. . Defaults to None.
        deletion_protection(bool, optional): Specifies whether this cluster can be deleted. If DeletionProtection is enabled, the cluster cannot be deleted unless it is modified and DeletionProtection is disabled. DeletionProtection protects clusters from being accidentally deleted. Defaults to None.
        global_cluster_identifier(str, optional): The cluster identifier of the new global cluster. Defaults to None.
        source_region(str, optional): The ID of the region that contains the source for the db cluster. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.docdb.db.cluster.init.create(
                ctx, db_cluster_identifier=value, engine=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.docdb.db.cluster.init.create db_cluster_identifier=value, engine=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="docdb",
        operation="create_db_cluster",
        op_kwargs={
            "AvailabilityZones": availability_zones,
            "BackupRetentionPeriod": backup_retention_period,
            "DBClusterIdentifier": db_cluster_identifier,
            "DBClusterParameterGroupName": db_cluster_parameter_group_name,
            "VpcSecurityGroupIds": vpc_security_group_ids,
            "DBSubnetGroupName": db_subnet_group_name,
            "Engine": engine,
            "EngineVersion": engine_version,
            "Port": port,
            "MasterUsername": master_username,
            "MasterUserPassword": master_user_password,
            "PreferredBackupWindow": preferred_backup_window,
            "PreferredMaintenanceWindow": preferred_maintenance_window,
            "Tags": tags,
            "StorageEncrypted": storage_encrypted,
            "KmsKeyId": kms_key_id,
            "PreSignedUrl": pre_signed_url,
            "EnableCloudwatchLogsExports": enable_cloudwatch_logs_exports,
            "DeletionProtection": deletion_protection,
            "GlobalClusterIdentifier": global_cluster_identifier,
            "SourceRegion": source_region,
        },
    )


async def delete(
    hub,
    ctx,
    db_cluster_identifier: str,
    skip_final_snapshot: bool = None,
    final_db_snapshot_identifier: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a previously provisioned cluster. When you delete a cluster, all automated backups for that cluster are deleted and can't be recovered. Manual DB cluster snapshots of the specified cluster are not deleted.

    Args:
        db_cluster_identifier(str): The cluster identifier for the cluster to be deleted. This parameter isn't case sensitive. Constraints:   Must match an existing DBClusterIdentifier.  .
        skip_final_snapshot(bool, optional):  Determines whether a final cluster snapshot is created before the cluster is deleted. If true is specified, no cluster snapshot is created. If false is specified, a cluster snapshot is created before the DB cluster is deleted.   If SkipFinalSnapshot is false, you must specify a FinalDBSnapshotIdentifier parameter.  Default: false . Defaults to None.
        final_db_snapshot_identifier(str, optional):  The cluster snapshot identifier of the new cluster snapshot created when SkipFinalSnapshot is set to false.    Specifying this parameter and also setting the SkipFinalShapshot parameter to true results in an error.   Constraints:   Must be from 1 to 255 letters, numbers, or hyphens.   The first character must be a letter.   Cannot end with a hyphen or contain two consecutive hyphens.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.docdb.db.cluster.init.delete(ctx, db_cluster_identifier=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.docdb.db.cluster.init.delete db_cluster_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="docdb",
        operation="delete_db_cluster",
        op_kwargs={
            "DBClusterIdentifier": db_cluster_identifier,
            "SkipFinalSnapshot": skip_final_snapshot,
            "FinalDBSnapshotIdentifier": final_db_snapshot_identifier,
        },
    )


async def describe_all(
    hub,
    ctx,
    db_cluster_identifier: str = None,
    filters: List = None,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about provisioned Amazon DocumentDB clusters. This API operation supports pagination. For certain management features such as cluster and instance lifecycle management, Amazon DocumentDB leverages operational technology that is shared with Amazon RDS and Amazon Neptune. Use the filterName=engine,Values=docdb filter parameter to return only Amazon DocumentDB clusters.

    Args:
        db_cluster_identifier(str, optional): The user-provided cluster identifier. If this parameter is specified, information from only the specific cluster is returned. This parameter isn't case sensitive. Constraints:   If provided, must match an existing DBClusterIdentifier.  . Defaults to None.
        filters(List, optional): A filter that specifies one or more clusters to describe. Supported filters:    db-cluster-id - Accepts cluster identifiers and cluster Amazon Resource Names (ARNs). The results list only includes information about the clusters identified by these ARNs.  . Defaults to None.
        max_records(int, optional):  The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token (marker) is included in the response so that the remaining results can be retrieved. Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.
        marker(str, optional): An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.docdb.db.cluster.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.docdb.db.cluster.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="docdb",
        operation="describe_db_clusters",
        op_kwargs={
            "DBClusterIdentifier": db_cluster_identifier,
            "Filters": filters,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )


async def failover(
    hub,
    ctx,
    db_cluster_identifier: str = None,
    target_db_instance_identifier: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Forces a failover for a cluster. A failover for a cluster promotes one of the Amazon DocumentDB replicas (read-only instances) in the cluster to be the primary instance (the cluster writer). If the primary instance fails, Amazon DocumentDB automatically fails over to an Amazon DocumentDB replica, if one exists. You can force a failover when you want to simulate a failure of a primary instance for testing.

    Args:
        db_cluster_identifier(str, optional): A cluster identifier to force a failover for. This parameter is not case sensitive. Constraints:   Must match the identifier of an existing DBCluster.  . Defaults to None.
        target_db_instance_identifier(str, optional): The name of the instance to promote to the primary instance. You must specify the instance identifier for an Amazon DocumentDB replica in the cluster. For example, mydbcluster-replica1. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.docdb.db.cluster.init.failover(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.docdb.db.cluster.init.failover
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="docdb",
        operation="failover_db_cluster",
        op_kwargs={
            "DBClusterIdentifier": db_cluster_identifier,
            "TargetDBInstanceIdentifier": target_db_instance_identifier,
        },
    )


async def modify(
    hub,
    ctx,
    db_cluster_identifier: str,
    new_db_cluster_identifier: str = None,
    apply_immediately: bool = None,
    backup_retention_period: int = None,
    db_cluster_parameter_group_name: str = None,
    vpc_security_group_ids: List = None,
    port: int = None,
    master_user_password: str = None,
    preferred_backup_window: str = None,
    preferred_maintenance_window: str = None,
    cloudwatch_logs_export_configuration: Dict = None,
    engine_version: str = None,
    deletion_protection: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies a setting for an Amazon DocumentDB cluster. You can change one or more database configuration parameters by specifying these parameters and the new values in the request.

    Args:
        db_cluster_identifier(str): The cluster identifier for the cluster that is being modified. This parameter is not case sensitive. Constraints:   Must match the identifier of an existing DBCluster.  .
        new_db_cluster_identifier(str, optional): The new cluster identifier for the cluster when renaming a cluster. This value is stored as a lowercase string. Constraints:   Must contain from 1 to 63 letters, numbers, or hyphens.   The first character must be a letter.   Cannot end with a hyphen or contain two consecutive hyphens.   Example: my-cluster2 . Defaults to None.
        apply_immediately(bool, optional): A value that specifies whether the changes in this request and any pending changes are asynchronously applied as soon as possible, regardless of the PreferredMaintenanceWindow setting for the cluster. If this parameter is set to false, changes to the cluster are applied during the next maintenance window. The ApplyImmediately parameter affects only the NewDBClusterIdentifier and MasterUserPassword values. If you set this parameter value to false, the changes to the NewDBClusterIdentifier and MasterUserPassword values are applied during the next maintenance window. All other changes are applied immediately, regardless of the value of the ApplyImmediately parameter. Default: false . Defaults to None.
        backup_retention_period(int, optional): The number of days for which automated backups are retained. You must specify a minimum value of 1. Default: 1 Constraints:   Must be a value from 1 to 35.  . Defaults to None.
        db_cluster_parameter_group_name(str, optional): The name of the cluster parameter group to use for the cluster. Defaults to None.
        vpc_security_group_ids(List, optional): A list of virtual private cloud (VPC) security groups that the cluster will belong to. Defaults to None.
        port(int, optional): The port number on which the cluster accepts connections. Constraints: Must be a value from 1150 to 65535.  Default: The same port as the original cluster. Defaults to None.
        master_user_password(str, optional): The password for the master database user. This password can contain any printable ASCII character except forward slash (/), double quote ("), or the "at" symbol (@). Constraints: Must contain from 8 to 100 characters. Defaults to None.
        preferred_backup_window(str, optional): The daily time range during which automated backups are created if automated backups are enabled, using the BackupRetentionPeriod parameter.  The default is a 30-minute window selected at random from an 8-hour block of time for each Region.  Constraints:   Must be in the format hh24:mi-hh24:mi.   Must be in Universal Coordinated Time (UTC).   Must not conflict with the preferred maintenance window.   Must be at least 30 minutes.  . Defaults to None.
        preferred_maintenance_window(str, optional): The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC). Format: ddd:hh24:mi-ddd:hh24:mi  The default is a 30-minute window selected at random from an 8-hour block of time for each Region, occurring on a random day of the week.  Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun Constraints: Minimum 30-minute window. Defaults to None.
        cloudwatch_logs_export_configuration(Dict, optional): The configuration setting for the log types to be enabled for export to Amazon CloudWatch Logs for a specific instance or cluster. The EnableLogTypes and DisableLogTypes arrays determine which logs are exported (or not exported) to CloudWatch Logs. Defaults to None.
        engine_version(str, optional): The version number of the database engine to which you want to upgrade. Modifying engine version is not supported on Amazon DocumentDB. Defaults to None.
        deletion_protection(bool, optional): Specifies whether this cluster can be deleted. If DeletionProtection is enabled, the cluster cannot be deleted unless it is modified and DeletionProtection is disabled. DeletionProtection protects clusters from being accidentally deleted. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.docdb.db.cluster.init.modify(ctx, db_cluster_identifier=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.docdb.db.cluster.init.modify db_cluster_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="docdb",
        operation="modify_db_cluster",
        op_kwargs={
            "DBClusterIdentifier": db_cluster_identifier,
            "NewDBClusterIdentifier": new_db_cluster_identifier,
            "ApplyImmediately": apply_immediately,
            "BackupRetentionPeriod": backup_retention_period,
            "DBClusterParameterGroupName": db_cluster_parameter_group_name,
            "VpcSecurityGroupIds": vpc_security_group_ids,
            "Port": port,
            "MasterUserPassword": master_user_password,
            "PreferredBackupWindow": preferred_backup_window,
            "PreferredMaintenanceWindow": preferred_maintenance_window,
            "CloudwatchLogsExportConfiguration": cloudwatch_logs_export_configuration,
            "EngineVersion": engine_version,
            "DeletionProtection": deletion_protection,
        },
    )


async def start(hub, ctx, db_cluster_identifier: str) -> Dict:
    r"""
    **Autogenerated function**

    Restarts the stopped cluster that is specified by DBClusterIdentifier. For more information, see Stopping and Starting an Amazon DocumentDB Cluster.

    Args:
        db_cluster_identifier(str): The identifier of the cluster to restart. Example: docdb-2019-05-28-15-24-52 .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.docdb.db.cluster.init.start(ctx, db_cluster_identifier=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.docdb.db.cluster.init.start db_cluster_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="docdb",
        operation="start_db_cluster",
        op_kwargs={"DBClusterIdentifier": db_cluster_identifier},
    )


async def stop(hub, ctx, db_cluster_identifier: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops the running cluster that is specified by DBClusterIdentifier. The cluster must be in the available state. For more information, see Stopping and Starting an Amazon DocumentDB Cluster.

    Args:
        db_cluster_identifier(str): The identifier of the cluster to stop. Example: docdb-2019-05-28-15-24-52 .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.docdb.db.cluster.init.stop(ctx, db_cluster_identifier=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.docdb.db.cluster.init.stop db_cluster_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="docdb",
        operation="stop_db_cluster",
        op_kwargs={"DBClusterIdentifier": db_cluster_identifier},
    )
