"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def restore(
    hub,
    ctx,
    db_cluster_identifier: str,
    snapshot_identifier: str,
    engine: str,
    availability_zones: List = None,
    engine_version: str = None,
    port: int = None,
    db_subnet_group_name: str = None,
    vpc_security_group_ids: List = None,
    tags: List = None,
    kms_key_id: str = None,
    enable_cloudwatch_logs_exports: List = None,
    deletion_protection: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new cluster from a snapshot or cluster snapshot. If a snapshot is specified, the target cluster is created from the source DB snapshot with a default configuration and default security group. If a cluster snapshot is specified, the target cluster is created from the source cluster restore point with the same configuration as the original source DB cluster, except that the new cluster is created with the default security group.

    Args:
        availability_zones(List, optional): Provides the list of Amazon EC2 Availability Zones that instances in the restored DB cluster can be created in. Defaults to None.
        db_cluster_identifier(str): The name of the cluster to create from the snapshot or cluster snapshot. This parameter isn't case sensitive. Constraints:   Must contain from 1 to 63 letters, numbers, or hyphens.   The first character must be a letter.   Cannot end with a hyphen or contain two consecutive hyphens.   Example: my-snapshot-id .
        snapshot_identifier(str): The identifier for the snapshot or cluster snapshot to restore from. You can use either the name or the Amazon Resource Name (ARN) to specify a cluster snapshot. However, you can use only the ARN to specify a snapshot. Constraints:   Must match the identifier of an existing snapshot.  .
        engine(str): The database engine to use for the new cluster. Default: The same as source. Constraint: Must be compatible with the engine of the source.
        engine_version(str, optional): The version of the database engine to use for the new cluster. Defaults to None.
        port(int, optional): The port number on which the new cluster accepts connections. Constraints: Must be a value from 1150 to 65535. Default: The same port as the original cluster. Defaults to None.
        db_subnet_group_name(str, optional): The name of the subnet group to use for the new cluster. Constraints: If provided, must match the name of an existing DBSubnetGroup. Example: mySubnetgroup . Defaults to None.
        vpc_security_group_ids(List, optional): A list of virtual private cloud (VPC) security groups that the new cluster will belong to. Defaults to None.
        tags(List, optional): The tags to be assigned to the restored cluster. Defaults to None.
        kms_key_id(str, optional): The KMS key identifier to use when restoring an encrypted cluster from a DB snapshot or cluster snapshot. The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a cluster with the same account that owns the KMS encryption key used to encrypt the new cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key. If you do not specify a value for the KmsKeyId parameter, then the following occurs:   If the snapshot or cluster snapshot in SnapshotIdentifier is encrypted, then the restored cluster is encrypted using the KMS key that was used to encrypt the snapshot or the cluster snapshot.   If the snapshot or the cluster snapshot in SnapshotIdentifier is not encrypted, then the restored DB cluster is not encrypted.  . Defaults to None.
        enable_cloudwatch_logs_exports(List, optional): A list of log types that must be enabled for exporting to Amazon CloudWatch Logs. Defaults to None.
        deletion_protection(bool, optional): Specifies whether this cluster can be deleted. If DeletionProtection is enabled, the cluster cannot be deleted unless it is modified and DeletionProtection is disabled. DeletionProtection protects clusters from being accidentally deleted. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.docdb.db.cluster.from_snapshot.restore(
                ctx, db_cluster_identifier=value, snapshot_identifier=value, engine=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.docdb.db.cluster.from_snapshot.restore db_cluster_identifier=value, snapshot_identifier=value, engine=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="docdb",
        operation="restore_db_cluster_from_snapshot",
        op_kwargs={
            "AvailabilityZones": availability_zones,
            "DBClusterIdentifier": db_cluster_identifier,
            "SnapshotIdentifier": snapshot_identifier,
            "Engine": engine,
            "EngineVersion": engine_version,
            "Port": port,
            "DBSubnetGroupName": db_subnet_group_name,
            "VpcSecurityGroupIds": vpc_security_group_ids,
            "Tags": tags,
            "KmsKeyId": kms_key_id,
            "EnableCloudwatchLogsExports": enable_cloudwatch_logs_exports,
            "DeletionProtection": deletion_protection,
        },
    )
