"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def remove(hub, ctx, resource_arn: str, tag_keys: List) -> Dict:
    r"""
    **Autogenerated function**

    Removes metadata tags from an DMS resource, including replication instance, endpoint, security group, and migration task. For more information, see  Tag  data type description.

    Args:
        resource_arn(str): An DMS resource from which you want to remove tag(s). The value for this parameter is an Amazon Resource Name (ARN).
        tag_keys(List): The tag key (name) of the tag to be removed.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.tags.from_resource.remove(
                ctx, resource_arn=value, tag_keys=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.tags.from_resource.remove resource_arn=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="remove_tags_from_resource",
        op_kwargs={"ResourceArn": resource_arn, "TagKeys": tag_keys},
    )
