"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    replication_task_arn: str,
    max_records: int = None,
    marker: str = None,
    filters: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns table statistics on the database migration task, including table name, rows inserted, rows updated, and rows deleted. Note that the "last updated" column the DMS console only indicates the time that DMS last updated the table statistics record for a table. It does not indicate the time of the last update to the table.

    Args:
        replication_task_arn(str): The Amazon Resource Name (ARN) of the replication task.
        max_records(int, optional):  The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.  Default: 100 Constraints: Minimum 20, maximum 500. Defaults to None.
        marker(str, optional):  An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. . Defaults to None.
        filters(List, optional): Filters applied to table statistics. Valid filter names: schema-name | table-name | table-state A combination of filters creates an AND condition where each record matches all specified filters. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.table.statistic.describe_all(
                ctx, replication_task_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.table.statistic.describe_all replication_task_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="describe_table_statistics",
        op_kwargs={
            "ReplicationTaskArn": replication_task_arn,
            "MaxRecords": max_records,
            "Marker": marker,
            "Filters": filters,
        },
    )
