"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def reload(
    hub,
    ctx,
    replication_task_arn: str,
    tables_to_reload: List,
    reload_option: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Reloads the target database table with the source data.

    Args:
        replication_task_arn(str): The Amazon Resource Name (ARN) of the replication task. .
        tables_to_reload(List): The name and schema of the table to be reloaded. .
        reload_option(str, optional): Options for reload. Specify data-reload to reload the data and re-validate it if validation is enabled. Specify validate-only to re-validate the table. This option applies only when validation is enabled for the task.  Valid values: data-reload, validate-only Default value is data-reload. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.table.init.reload(
                ctx, replication_task_arn=value, tables_to_reload=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.table.init.reload replication_task_arn=value, tables_to_reload=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="reload_tables",
        op_kwargs={
            "ReplicationTaskArn": replication_task_arn,
            "TablesToReload": tables_to_reload,
            "ReloadOption": reload_option,
        },
    )
