"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    replication_task_identifier: str,
    source_endpoint_arn: str,
    target_endpoint_arn: str,
    replication_instance_arn: str,
    migration_type: str,
    table_mappings: str,
    replication_task_settings: str = None,
    cdc_start_time: str = None,
    cdc_start_position: str = None,
    cdc_stop_position: str = None,
    tags: List = None,
    task_data: str = None,
    resource_identifier: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a replication task using the specified parameters.

    Args:
        replication_task_identifier(str): An identifier for the replication task. Constraints:   Must contain 1-255 alphanumeric characters or hyphens.   First character must be a letter.   Cannot end with a hyphen or contain two consecutive hyphens.  .
        source_endpoint_arn(str): An Amazon Resource Name (ARN) that uniquely identifies the source endpoint.
        target_endpoint_arn(str): An Amazon Resource Name (ARN) that uniquely identifies the target endpoint.
        replication_instance_arn(str): The Amazon Resource Name (ARN) of a replication instance.
        migration_type(str): The migration type. Valid values: full-load | cdc | full-load-and-cdc .
        table_mappings(str): The table mappings for the task, in JSON format. For more information, see Using Table Mapping to Specify Task Settings in the Database Migration Service User Guide. .
        replication_task_settings(str, optional): Overall settings for the task, in JSON format. For more information, see Specifying Task Settings for Database Migration Service Tasks in the Database Migration Service User Guide. . Defaults to None.
        cdc_start_time(str, optional): Indicates the start time for a change data capture (CDC) operation. Use either CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start. Specifying both values results in an error. Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”. Defaults to None.
        cdc_start_position(str, optional): Indicates when you want a change data capture (CDC) operation to start. Use either CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start. Specifying both values results in an error.  The value can be in date, checkpoint, or LSN/SCN format. Date Example: --cdc-start-position “2018-03-08T12:12:12” Checkpoint Example: --cdc-start-position "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93" LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”  When you use this task setting with a source PostgreSQL database, a logical replication slot should already be created and associated with the source endpoint. You can verify this by setting the slotName extra connection attribute to the name of this logical replication slot. For more information, see Extra Connection Attributes When Using PostgreSQL as a Source for DMS. . Defaults to None.
        cdc_stop_position(str, optional): Indicates when you want a change data capture (CDC) operation to stop. The value can be either server time or commit time. Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12” Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “. Defaults to None.
        tags(List, optional): One or more tags to be assigned to the replication task. Defaults to None.
        task_data(str, optional): Supplemental information that the task requires to migrate the data for certain source and target endpoints. For more information, see Specifying Supplemental Data for Task Settings in the Database Migration Service User Guide. . Defaults to None.
        resource_identifier(str, optional): A friendly name for the resource identifier at the end of the EndpointArn response parameter that is returned in the created Endpoint object. The value for this parameter can have up to 31 characters. It can contain only ASCII letters, digits, and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens, and can only begin with a letter, such as Example-App-ARN1. For example, this value might result in the EndpointArn value arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1. If you don't specify a ResourceIdentifier value, DMS generates a default identifier value for the end of EndpointArn. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.replication.task.init.create(
                ctx,
                replication_task_identifier=value,
                source_endpoint_arn=value,
                target_endpoint_arn=value,
                replication_instance_arn=value,
                migration_type=value,
                table_mappings=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.replication.task.init.create replication_task_identifier=value, source_endpoint_arn=value, target_endpoint_arn=value, replication_instance_arn=value, migration_type=value, table_mappings=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="create_replication_task",
        op_kwargs={
            "ReplicationTaskIdentifier": replication_task_identifier,
            "SourceEndpointArn": source_endpoint_arn,
            "TargetEndpointArn": target_endpoint_arn,
            "ReplicationInstanceArn": replication_instance_arn,
            "MigrationType": migration_type,
            "TableMappings": table_mappings,
            "ReplicationTaskSettings": replication_task_settings,
            "CdcStartTime": cdc_start_time,
            "CdcStartPosition": cdc_start_position,
            "CdcStopPosition": cdc_stop_position,
            "Tags": tags,
            "TaskData": task_data,
            "ResourceIdentifier": resource_identifier,
        },
    )


async def delete(hub, ctx, replication_task_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified replication task.

    Args:
        replication_task_arn(str): The Amazon Resource Name (ARN) of the replication task to be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.replication.task.init.delete(
                ctx, replication_task_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.replication.task.init.delete replication_task_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="delete_replication_task",
        op_kwargs={"ReplicationTaskArn": replication_task_arn},
    )


async def describe_all(
    hub,
    ctx,
    filters: List = None,
    max_records: int = None,
    marker: str = None,
    without_settings: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about replication tasks for your account in the current region.

    Args:
        filters(List, optional): Filters applied to replication tasks. Valid filter names: replication-task-arn | replication-task-id | migration-type | endpoint-arn | replication-instance-arn. Defaults to None.
        max_records(int, optional):  The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.  Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.
        marker(str, optional):  An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. . Defaults to None.
        without_settings(bool, optional): An option to set to avoid returning information about settings. Use this to reduce overhead when setting information is too large. To use this option, choose true; otherwise, choose false (the default). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.replication.task.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.replication.task.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="describe_replication_tasks",
        op_kwargs={
            "Filters": filters,
            "MaxRecords": max_records,
            "Marker": marker,
            "WithoutSettings": without_settings,
        },
    )


async def modify(
    hub,
    ctx,
    replication_task_arn: str,
    replication_task_identifier: str = None,
    migration_type: str = None,
    table_mappings: str = None,
    replication_task_settings: str = None,
    cdc_start_time: str = None,
    cdc_start_position: str = None,
    cdc_stop_position: str = None,
    task_data: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the specified replication task. You can't modify the task endpoints. The task must be stopped before you can modify it.  For more information about DMS tasks, see Working with Migration Tasks in the Database Migration Service User Guide.

    Args:
        replication_task_arn(str): The Amazon Resource Name (ARN) of the replication task.
        replication_task_identifier(str, optional): The replication task identifier. Constraints:   Must contain 1-255 alphanumeric characters or hyphens.   First character must be a letter.   Cannot end with a hyphen or contain two consecutive hyphens.  . Defaults to None.
        migration_type(str, optional): The migration type. Valid values: full-load | cdc | full-load-and-cdc . Defaults to None.
        table_mappings(str, optional): When using the CLI or boto3, provide the path of the JSON file that contains the table mappings. Precede the path with file://. For example, --table-mappings file://mappingfile.json. When working with the DMS API, provide the JSON as the parameter value. . Defaults to None.
        replication_task_settings(str, optional): JSON file that contains settings for the task, such as task metadata settings. Defaults to None.
        cdc_start_time(str, optional): Indicates the start time for a change data capture (CDC) operation. Use either CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start. Specifying both values results in an error. Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”. Defaults to None.
        cdc_start_position(str, optional): Indicates when you want a change data capture (CDC) operation to start. Use either CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start. Specifying both values results in an error.  The value can be in date, checkpoint, or LSN/SCN format. Date Example: --cdc-start-position “2018-03-08T12:12:12” Checkpoint Example: --cdc-start-position "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93" LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”  When you use this task setting with a source PostgreSQL database, a logical replication slot should already be created and associated with the source endpoint. You can verify this by setting the slotName extra connection attribute to the name of this logical replication slot. For more information, see Extra Connection Attributes When Using PostgreSQL as a Source for DMS. . Defaults to None.
        cdc_stop_position(str, optional): Indicates when you want a change data capture (CDC) operation to stop. The value can be either server time or commit time. Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12” Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “. Defaults to None.
        task_data(str, optional): Supplemental information that the task requires to migrate the data for certain source and target endpoints. For more information, see Specifying Supplemental Data for Task Settings in the Database Migration Service User Guide. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.replication.task.init.modify(
                ctx, replication_task_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.replication.task.init.modify replication_task_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="modify_replication_task",
        op_kwargs={
            "ReplicationTaskArn": replication_task_arn,
            "ReplicationTaskIdentifier": replication_task_identifier,
            "MigrationType": migration_type,
            "TableMappings": table_mappings,
            "ReplicationTaskSettings": replication_task_settings,
            "CdcStartTime": cdc_start_time,
            "CdcStartPosition": cdc_start_position,
            "CdcStopPosition": cdc_stop_position,
            "TaskData": task_data,
        },
    )


async def move(
    hub, ctx, replication_task_arn: str, target_replication_instance_arn: str
) -> Dict:
    r"""
    **Autogenerated function**

    Moves a replication task from its current replication instance to a different target replication instance using the specified parameters. The target replication instance must be created with the same or later DMS version as the current replication instance.

    Args:
        replication_task_arn(str): The Amazon Resource Name (ARN) of the task that you want to move.
        target_replication_instance_arn(str): The ARN of the replication instance where you want to move the task to.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.replication.task.init.move(
                ctx, replication_task_arn=value, target_replication_instance_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.replication.task.init.move replication_task_arn=value, target_replication_instance_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="move_replication_task",
        op_kwargs={
            "ReplicationTaskArn": replication_task_arn,
            "TargetReplicationInstanceArn": target_replication_instance_arn,
        },
    )


async def start(
    hub,
    ctx,
    replication_task_arn: str,
    start_replication_task_type: str,
    cdc_start_time: str = None,
    cdc_start_position: str = None,
    cdc_stop_position: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts the replication task. For more information about DMS tasks, see Working with Migration Tasks  in the Database Migration Service User Guide.

    Args:
        replication_task_arn(str): The Amazon Resource Name (ARN) of the replication task to be started.
        start_replication_task_type(str): A type of replication task.
        cdc_start_time(str, optional): Indicates the start time for a change data capture (CDC) operation. Use either CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start. Specifying both values results in an error. Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”. Defaults to None.
        cdc_start_position(str, optional): Indicates when you want a change data capture (CDC) operation to start. Use either CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start. Specifying both values results in an error.  The value can be in date, checkpoint, or LSN/SCN format. Date Example: --cdc-start-position “2018-03-08T12:12:12” Checkpoint Example: --cdc-start-position "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93" LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”  When you use this task setting with a source PostgreSQL database, a logical replication slot should already be created and associated with the source endpoint. You can verify this by setting the slotName extra connection attribute to the name of this logical replication slot. For more information, see Extra Connection Attributes When Using PostgreSQL as a Source for DMS. . Defaults to None.
        cdc_stop_position(str, optional): Indicates when you want a change data capture (CDC) operation to stop. The value can be either server time or commit time. Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12” Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.replication.task.init.start(
                ctx, replication_task_arn=value, start_replication_task_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.replication.task.init.start replication_task_arn=value, start_replication_task_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="start_replication_task",
        op_kwargs={
            "ReplicationTaskArn": replication_task_arn,
            "StartReplicationTaskType": start_replication_task_type,
            "CdcStartTime": cdc_start_time,
            "CdcStartPosition": cdc_start_position,
            "CdcStopPosition": cdc_stop_position,
        },
    )


async def stop(hub, ctx, replication_task_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops the replication task.

    Args:
        replication_task_arn(str): The Amazon Resource Name(ARN) of the replication task to be stopped.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.replication.task.init.stop(ctx, replication_task_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.replication.task.init.stop replication_task_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="stop_replication_task",
        op_kwargs={"ReplicationTaskArn": replication_task_arn},
    )
