"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    replication_task_arn: str = None,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the task assessment results from the Amazon S3 bucket that DMS creates in your account. This action always returns the latest results. For more information about DMS task assessments, see Creating a task assessment report in the  Database Migration Service User Guide.

    Args:
        replication_task_arn(str, optional): The Amazon Resource Name (ARN) string that uniquely identifies the task. When this input parameter is specified, the API returns only one result and ignore the values of the MaxRecords and Marker parameters. . Defaults to None.
        max_records(int, optional):  The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.  Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.
        marker(str, optional):  An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dms.replication.task.assessment.result.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dms.replication.task.assessment.result.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dms",
        operation="describe_replication_task_assessment_results",
        op_kwargs={
            "ReplicationTaskArn": replication_task_arn,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )
